import { TypeSafeApiAsyncModelBuildOutputOptions } from "../type-safe-api-async-model-build";
import { TypeSafeApiModelBuildOutputOptions } from "../type-safe-api-model-build";
import { SmithyBaseProject, SmithyBaseProjectOptions } from "./smithy-base-project";
import { SmithyProjectDefinition } from "./smithy-project-definition";
import { SmithyServiceProjectDefinition, SmithyServiceProjectDefinitionOptions } from "./smithy-service-project-definition";
/**
 * Options for the Smithy WebSocket API model project
 */
export interface SmithyAsyncModelProjectOptions extends SmithyBaseProjectOptions, SmithyServiceProjectDefinitionOptions, TypeSafeApiModelBuildOutputOptions, TypeSafeApiAsyncModelBuildOutputOptions {
}
/**
 * Smithy model project for a WebSocket API
 */
export declare class SmithyAsyncModelProject extends SmithyBaseProject {
    /**
     * Name of the API
     */
    readonly apiName: string;
    /**
     * Smithy model and build settings
     */
    readonly definition: SmithyServiceProjectDefinition;
    constructor(options: SmithyAsyncModelProjectOptions);
    smithyProjectDefinition(): SmithyProjectDefinition;
}
