/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Component, Project } from "projen";
/**
 * Output for the OpenAPI parse/bundle task
 */
export interface TypeSafeApiModelBuildOutputOptions {
    /**
     * Path of the parsed/bundled OpenAPI specification (relative to the project root)
     */
    readonly parsedSpecFile: string;
}
/**
 * Options for configuring the OpenAPI parse/bundle task
 */
export interface TypeSafeApiModelBuildOptions extends TypeSafeApiModelBuildOutputOptions {
    /**
     * Path to the OpenAPI specification
     */
    readonly openApiSpecificationPath: string;
    /**
     * Optional path to the Smithy JSON model (for Smithy projects only)
     */
    readonly smithyJsonModelPath?: string;
}
/**
 * Adds the build task for parsing/bundling an OpenAPI spec ready for use by code generation projects
 */
export declare class TypeSafeApiModelBuild extends Component {
    constructor(project: Project, options: TypeSafeApiModelBuildOptions);
}
