export declare namespace AwsAsset {
    const Categories: {
        readonly analytics: "analytics/category_icon";
        readonly application_integration: "application_integration/category_icon";
        readonly blockchain: "blockchain/category_icon";
        readonly business_applications: "business_applications/category_icon";
        readonly cloud_financial_management: "cloud_financial_management/category_icon";
        readonly compute: "compute/category_icon";
        readonly containers: "containers/category_icon";
        readonly customer_enablement: "customer_enablement/category_icon";
        readonly database: "database/category_icon";
        readonly developer_tools: "developer_tools/category_icon";
        readonly end_user_computing: "end_user_computing/category_icon";
        readonly front_end_web_mobile: "front_end_web_mobile/category_icon";
        readonly game_tech: "game_tech/category_icon";
        readonly internet_of_things: "internet_of_things/category_icon";
        readonly machine_learning: "machine_learning/category_icon";
        readonly management_governance: "management_governance/category_icon";
        readonly media_services: "media_services/category_icon";
        readonly migration_transfer: "migration_transfer/category_icon";
        readonly networking_content_delivery: "networking_content_delivery/category_icon";
        readonly quantum_technologies: "quantum_technologies/category_icon";
        readonly robotics: "robotics/category_icon";
        readonly satellite: "satellite/category_icon";
        readonly security_identity_compliance: "security_identity_compliance/category_icon";
        readonly serverless: "serverless/category_icon";
        readonly storage: "storage/category_icon";
        readonly vr_ar: "vr_ar/category_icon";
    };
    type Category = keyof typeof Categories;
    const Services: {
        readonly activate: "customer_enablement/activate/service_icon";
        readonly alexa_for_business: "business_applications/alexa_for_business/service_icon";
        readonly amplify: "front_end_web_mobile/amplify/service_icon";
        readonly apache_mxnet_on_aws: "machine_learning/apache_mxnet_on_aws/service_icon";
        readonly api_gateway: "application_integration/api_gateway/service_icon";
        readonly app_mesh: "networking_content_delivery/app_mesh/service_icon";
        readonly app_runner: "compute/app_runner/service_icon";
        readonly appconfig: "management_governance/appconfig/service_icon";
        readonly appflow: "application_integration/appflow/service_icon";
        readonly application_auto_scaling: "management_governance/application_auto_scaling/service_icon";
        readonly application_cost_profiler: "cloud_financial_management/application_cost_profiler/service_icon";
        readonly application_discovery_service: "migration_transfer/application_discovery_service/service_icon";
        readonly application_migration_service: "migration_transfer/application_migration_service/service_icon";
        readonly appstream: "end_user_computing/appstream/service_icon";
        readonly appsync: "application_integration/appsync/service_icon";
        readonly aps: "management_governance/aps/service_icon";
        readonly artifact: "security_identity_compliance/artifact/service_icon";
        readonly athena: "analytics/athena/service_icon";
        readonly audit_manager: "security_identity_compliance/audit_manager/service_icon";
        readonly augmented_ai_a2i: "machine_learning/augmented_ai_a2i/service_icon";
        readonly aurora: "database/aurora/service_icon";
        readonly auto_scaling: "management_governance/auto_scaling/service_icon";
        readonly backint_agent: "management_governance/backint_agent/service_icon";
        readonly backup: "storage/backup/service_icon";
        readonly batch: "compute/batch/service_icon";
        readonly billing_conductor: "cloud_financial_management/billing_conductor/service_icon";
        readonly bottlerocket: "compute/bottlerocket/service_icon";
        readonly braket: "quantum_technologies/braket/service_icon";
        readonly budgets: "cloud_financial_management/budgets/service_icon";
        readonly certificate_manager: "security_identity_compliance/certificate_manager/service_icon";
        readonly chatbot: "management_governance/chatbot/service_icon";
        readonly chime: "business_applications/chime/service_icon";
        readonly chime_sdk: "business_applications/chime_sdk/service_icon";
        readonly chime_voice_connector: "business_applications/chime_voice_connector/service_icon";
        readonly client_vpn: "networking_content_delivery/client_vpn/service_icon";
        readonly cloud9: "developer_tools/cloud9/service_icon";
        readonly cloud_control_api: "developer_tools/cloud_control_api/service_icon";
        readonly cloud_development_kit: "developer_tools/cloud_development_kit/service_icon";
        readonly cloud_directory: "networking_content_delivery/cloud_directory/service_icon";
        readonly cloud_map: "networking_content_delivery/cloud_map/service";
        readonly cloud_wan: "networking_content_delivery/cloud_wan/service_icon";
        readonly cloudendure_disaster_recovery: "storage/cloudendure_disaster_recovery/service_icon";
        readonly cloudformation: "management_governance/cloudformation/service_icon";
        readonly cloudfront: "networking_content_delivery/cloudfront/service_icon";
        readonly cloudhsm: "security_identity_compliance/cloudhsm/service_icon";
        readonly cloudsearch: "analytics/cloudsearch/service_icon";
        readonly cloudshell: "developer_tools/cloudshell/service_icon";
        readonly cloudtrail: "management_governance/cloudtrail/service_icon";
        readonly cloudwatch: "management_governance/cloudwatch/service_icon";
        readonly codeartifact: "developer_tools/codeartifact/service_icon";
        readonly codebuild: "developer_tools/codebuild/service_icon";
        readonly codecommit: "developer_tools/codecommit/service_icon";
        readonly codedeploy: "developer_tools/codedeploy/service_icon";
        readonly codeguru: "machine_learning/codeguru/service_icon";
        readonly codepipeline: "developer_tools/codepipeline/service_icon";
        readonly codestar: "developer_tools/codestar/service_icon";
        readonly codewhisperer: "machine_learning/codewhisperer/service_icon";
        readonly cognito: "security_identity_compliance/cognito/service_icon";
        readonly command_line_interface: "developer_tools/command_line_interface/service_icon";
        readonly comprehend: "machine_learning/comprehend/service_icon";
        readonly comprehend_medical: "machine_learning/comprehend_medical/service_icon";
        readonly compute_optimizer: "compute/compute_optimizer/service_icon";
        readonly config: "management_governance/config/service_icon";
        readonly connect: "business_applications/connect/service_icon";
        readonly console_mobile_application: "application_integration/console_mobile_application/service_icon";
        readonly control_tower: "management_governance/control_tower/service_icon";
        readonly corretto: "developer_tools/corretto/service_icon";
        readonly cost_and_usage_report: "cloud_financial_management/cost_and_usage_report/service_icon";
        readonly cost_explorer: "cloud_financial_management/cost_explorer/service_icon";
        readonly data_exchange: "analytics/data_exchange/service_icon";
        readonly data_pipeline: "analytics/data_pipeline/service_icon";
        readonly database_migration_service: "database/database_migration_service/service_icon";
        readonly datasync: "migration_transfer/datasync/service_icon";
        readonly deep_learning_amis: "machine_learning/deep_learning_amis/service_icon";
        readonly deep_learning_containers: "machine_learning/deep_learning_containers/service_icon";
        readonly deepcomposer: "machine_learning/deepcomposer/service_icon";
        readonly deeplens: "machine_learning/deeplens/service_icon";
        readonly deepracer: "machine_learning/deepracer/service_icon";
        readonly detective: "security_identity_compliance/detective/service_icon";
        readonly device_farm: "front_end_web_mobile/device_farm/service_icon";
        readonly devops_guru: "machine_learning/devops_guru/service_icon";
        readonly direct_connect: "networking_content_delivery/direct_connect/service_icon";
        readonly directory_service: "security_identity_compliance/directory_service/service_icon";
        readonly distro_for_opentelemetry: "management_governance/distro_for_opentelemetry/service_icon";
        readonly documentdb: "database/documentdb/service_icon";
        readonly dynamodb: "database/dynamodb/service_icon";
        readonly ebs: "storage/ebs/service_icon";
        readonly ec2: "compute/ec2/service_icon";
        readonly ec2_auto_scaling: "compute/ec2_auto_scaling/service_icon";
        readonly ec2_image_builder: "compute/ec2_image_builder/service_icon";
        readonly ecr: "containers/ecr/service_icon";
        readonly ecs: "containers/ecs/service";
        readonly ecs_anywhere: "containers/ecs_anywhere/service_icon";
        readonly efs: "storage/efs/service_icon";
        readonly eks: "containers/eks/service_icon";
        readonly eks_anywhere: "containers/eks_anywhere/service_icon";
        readonly eks_cloud: "containers/eks_cloud/service_icon";
        readonly eks_distro: "containers/eks_distro/service_icon";
        readonly elastic_beanstalk: "compute/elastic_beanstalk/service_icon";
        readonly elastic_fabric_adapter: "compute/elastic_fabric_adapter/service_icon";
        readonly elastic_inference: "machine_learning/elastic_inference/service_icon";
        readonly elastic_load_balancing: "networking_content_delivery/elastic_load_balancing/service_icon";
        readonly elastic_transcoder: "media_services/elastic_transcoder/service_icon";
        readonly elasticache: "database/elasticache/service_icon";
        readonly elemental_appliances_software: "media_services/elemental_appliances_software/service_icon";
        readonly elemental_conductor: "media_services/elemental_conductor/service_icon";
        readonly elemental_delta: "media_services/elemental_delta/service_icon";
        readonly elemental_link: "media_services/elemental_link/service_icon";
        readonly elemental_live: "media_services/elemental_live/service_icon";
        readonly elemental_mediaconnect: "media_services/elemental_mediaconnect/service_icon";
        readonly elemental_mediaconvert: "media_services/elemental_mediaconvert/service_icon";
        readonly elemental_medialive: "media_services/elemental_medialive/service_icon";
        readonly elemental_mediapackage: "media_services/elemental_mediapackage/service_icon";
        readonly elemental_mediastore: "media_services/elemental_mediastore/service_icon";
        readonly elemental_mediatailor: "media_services/elemental_mediatailor/service_icon";
        readonly elemental_server: "media_services/elemental_server/service_icon";
        readonly emr: "analytics/emr/service_icon";
        readonly eventbridge: "application_integration/eventbridge/service_icon";
        readonly express_workflows: "application_integration/express_workflows/service_icon";
        readonly fargate: "containers/fargate/service_icon";
        readonly fault_injection_simulator: "management_governance/fault_injection_simulator/service_icon";
        readonly finspace: "analytics/finspace/service_icon";
        readonly firewall_manager: "security_identity_compliance/firewall_manager/service_icon";
        readonly forecast: "machine_learning/forecast/service_icon";
        readonly fraud_detector: "machine_learning/fraud_detector/service_icon";
        readonly freertos: "internet_of_things/freertos/service_icon";
        readonly fsx: "storage/fsx/service_icon";
        readonly fsx_for_lustre: "storage/fsx_for_lustre/service_icon";
        readonly fsx_for_netapp_ontap: "storage/fsx_for_netapp_ontap/service_icon";
        readonly fsx_for_openzfs: "storage/fsx_for_openzfs/service_icon";
        readonly fsx_for_wfs: "storage/fsx_for_wfs/service_icon";
        readonly gamekit: "game_tech/gamekit/service_icon";
        readonly gamelift: "game_tech/gamelift/service_icon";
        readonly gamesparks: "game_tech/gamesparks/service_icon";
        readonly genomics_cli: "compute/genomics_cli/service_icon";
        readonly global_accelerator: "networking_content_delivery/global_accelerator/service_icon";
        readonly glue: "analytics/glue/service_icon";
        readonly glue_databrew: "analytics/glue_databrew/service_icon";
        readonly glue_elastic_views: "analytics/glue_elastic_views/service_icon";
        readonly ground_station: "satellite/ground_station/service_icon";
        readonly guardduty: "security_identity_compliance/guardduty/service_icon";
        readonly healthlake: "machine_learning/healthlake/service_icon";
        readonly honeycode: "business_applications/honeycode/service_icon";
        readonly iam: "security_identity_compliance/iam/service_icon";
        readonly iam_identity_center: "security_identity_compliance/iam_identity_center/service_icon";
        readonly inspector: "security_identity_compliance/inspector/service_icon";
        readonly interactive_video_service: "media_services/interactive_video_service/service_icon";
        readonly iot_1_click: "internet_of_things/iot_1_click/service_icon";
        readonly iot_analytics: "internet_of_things/iot_analytics/service_icon";
        readonly iot_button: "internet_of_things/iot_button/service_icon";
        readonly iot_core: "internet_of_things/iot_core/service_icon";
        readonly iot_device_defender: "internet_of_things/iot_device_defender/service_icon";
        readonly iot_device_management: "internet_of_things/iot_device_management/service_icon";
        readonly iot_edukit: "internet_of_things/iot_edukit/service_icon";
        readonly iot_events: "internet_of_things/iot_events/service_icon";
        readonly iot_expresslink: "internet_of_things/iot_expresslink/service_icon";
        readonly iot_fleetwise: "internet_of_things/iot_fleetwise/service_icon";
        readonly iot_greengrass: "internet_of_things/iot_greengrass/service_icon";
        readonly iot_roborunner: "internet_of_things/iot_roborunner/service_icon";
        readonly iot_sitewise: "internet_of_things/iot_sitewise/service_icon";
        readonly iot_things_graph: "internet_of_things/iot_things_graph/service_icon";
        readonly iot_twinmaker: "internet_of_things/iot_twinmaker/service_icon";
        readonly iq: "customer_enablement/iq/service_icon";
        readonly kendra: "machine_learning/kendra/service_icon";
        readonly key_management_service: "security_identity_compliance/key_management_service/service_icon";
        readonly keyspaces: "database/keyspaces/service_icon";
        readonly kinesis: "analytics/kinesis/service_icon";
        readonly kinesis_data_analytics: "analytics/kinesis_data_analytics/service_icon";
        readonly kinesis_data_streams: "analytics/kinesis_data_streams/service_icon";
        readonly kinesis_firehose: "analytics/kinesis_firehose/service_icon";
        readonly kinesis_video_streams: "analytics/kinesis_video_streams/service_icon";
        readonly lake_formation: "analytics/lake_formation/service_icon";
        readonly lambda: "compute/lambda/service_icon";
        readonly launch_wizard: "management_governance/launch_wizard/service_icon";
        readonly lex: "machine_learning/lex/service_icon";
        readonly license_manager: "management_governance/license_manager/service_icon";
        readonly lightsail: "compute/lightsail/service_icon";
        readonly local_zones: "compute/local_zones/service_icon";
        readonly location_service: "front_end_web_mobile/location_service/service_icon";
        readonly lookout_for_equipment: "machine_learning/lookout_for_equipment/service_icon";
        readonly lookout_for_metrics: "machine_learning/lookout_for_metrics/service_icon";
        readonly lookout_for_vision: "machine_learning/lookout_for_vision/service_icon";
        readonly lumberyard: "game_tech/lumberyard/service_icon";
        readonly macie: "security_identity_compliance/macie/service_icon";
        readonly mainframe_modernization: "migration_transfer/mainframe_modernization/service_icon";
        readonly managed_blockchain: "blockchain/managed_blockchain/service_icon";
        readonly managed_grafana: "management_governance/managed_grafana/service_icon";
        readonly managed_services: "customer_enablement/managed_services/service_icon";
        readonly management_console: "management_governance/management_console/service_icon";
        readonly memorydb_for_redis: "database/memorydb_for_redis/service_icon";
        readonly migration_evaluator: "migration_transfer/migration_evaluator/service_icon";
        readonly migration_hub: "migration_transfer/migration_hub/service_icon";
        readonly monitron: "machine_learning/monitron/service_icon";
        readonly mq: "application_integration/mq/service_icon";
        readonly msk: "analytics/msk/service_icon";
        readonly mwaa: "application_integration/mwaa/service_icon";
        readonly neptune: "database/neptune/service_icon";
        readonly network_firewall: "security_identity_compliance/network_firewall/service_icon";
        readonly neuron: "machine_learning/neuron/service_icon";
        readonly nice_dcv: "compute/nice_dcv/service_icon";
        readonly nice_enginframe: "compute/nice_enginframe/service_icon";
        readonly nimble_studio: "media_services/nimble_studio/service_icon";
        readonly nitro_enclaves: "compute/nitro_enclaves/service_icon";
        readonly open_3d_engine: "game_tech/open_3d_engine/service_icon";
        readonly opensearch: "analytics/opensearch/service_icon";
        readonly opsworks: "management_governance/opsworks/service_icon";
        readonly organizations: "management_governance/organizations/service_icon";
        readonly outposts_family: "compute/outposts_family/service_icon";
        readonly outposts_rack: "compute/outposts_rack/service_icon";
        readonly outposts_servers: "compute/outposts_servers/service_icon";
        readonly panorama: "machine_learning/panorama/service_icon";
        readonly parallelcluster: "compute/parallelcluster/service_icon";
        readonly personal_health_dashboard: "management_governance/personal_health_dashboard/service_icon";
        readonly personalize: "machine_learning/personalize/service_icon";
        readonly pinpoint: "business_applications/pinpoint/service_icon";
        readonly pinpoint_apis: "business_applications/pinpoint_apis/service_icon";
        readonly polly: "machine_learning/polly/service_icon";
        readonly private_5g: "networking_content_delivery/private_5g/service_icon";
        readonly privatelink: "networking_content_delivery/privatelink/service_icon";
        readonly professional_services: "customer_enablement/professional_services/service_icon";
        readonly proton: "management_governance/proton/service_icon";
        readonly quantum_ledger_database: "blockchain/quantum_ledger_database/service_icon";
        readonly quicksight: "analytics/quicksight/service_icon";
        readonly rds: "database/rds/service_icon";
        readonly rds_on_vmware: "database/rds_on_vmware/service_icon";
        readonly red_hat_openshift: "containers/red_hat_openshift/service_icon";
        readonly redshift: "analytics/redshift/service_icon";
        readonly rekognition: "machine_learning/rekognition/service_icon";
        readonly repost: "customer_enablement/repost/service_icon";
        readonly reserved_instance_reporting: "cloud_financial_management/reserved_instance_reporting/service_icon";
        readonly resilience_hub: "management_governance/resilience_hub/service_icon";
        readonly resource_access_manager: "security_identity_compliance/resource_access_manager/service_icon";
        readonly robomaker: "robotics/robomaker/service_icon";
        readonly route_53: "networking_content_delivery/route_53/service_icon";
        readonly s3: "storage/s3/service_icon";
        readonly s3_glacier: "storage/s3_glacier/service_icon";
        readonly s3_on_outposts: "storage/s3_on_outposts/service_icon";
        readonly sagemaker: "machine_learning/sagemaker/service_icon";
        readonly sagemaker_ground_truth: "machine_learning/sagemaker_ground_truth/service_icon";
        readonly sagemaker_studio_lab: "machine_learning/sagemaker_studio_lab/service_icon";
        readonly savings_plans: "cloud_financial_management/savings_plans/service_icon";
        readonly secrets_manager: "security_identity_compliance/secrets_manager/service_icon";
        readonly security_hub: "security_identity_compliance/security_hub/service_icon";
        readonly server_migration_service: "migration_transfer/server_migration_service/service_icon";
        readonly serverless_application_repository: "compute/serverless_application_repository/service_icon";
        readonly service_catalog: "management_governance/service_catalog/service_icon";
        readonly ses: "business_applications/ses/service_icon";
        readonly shield: "security_identity_compliance/shield/service_icon";
        readonly signer: "security_identity_compliance/signer/service_icon";
        readonly site_to_site_vpn: "networking_content_delivery/site_to_site_vpn/service_icon";
        readonly snowball: "storage/snowball/service_icon";
        readonly snowball_edge: "storage/snowball_edge/service_icon";
        readonly snowcone: "storage/snowcone/service_icon";
        readonly snowmobile: "storage/snowmobile/service_icon";
        readonly sns: "application_integration/sns/service_icon";
        readonly sqs: "application_integration/sqs/service_icon";
        readonly ssm: "management_governance/ssm/service_icon";
        readonly step_functions: "application_integration/step_functions/service_icon";
        readonly storage_gateway: "storage/storage_gateway/service_icon";
        readonly sumerian: "vr_ar/sumerian/service_icon";
        readonly support: "customer_enablement/support/service_icon";
        readonly systems_manager_incident_manager: "management_governance/systems_manager_incident_manager/service_icon";
        readonly tensorflow_on_aws: "machine_learning/tensorflow_on_aws/service_icon";
        readonly textract: "machine_learning/textract/service_icon";
        readonly thinkbox_deadline: "compute/thinkbox_deadline/service_icon";
        readonly thinkbox_frost: "compute/thinkbox_frost/service_icon";
        readonly thinkbox_krakatoa: "compute/thinkbox_krakatoa/service_icon";
        readonly thinkbox_sequoia: "compute/thinkbox_sequoia/service_icon";
        readonly thinkbox_stoke: "compute/thinkbox_stoke/service_icon";
        readonly thinkbox_xmesh: "compute/thinkbox_xmesh/service_icon";
        readonly timestream: "database/timestream/service_icon";
        readonly tools_and_sdks: "developer_tools/tools_and_sdks/service_icon";
        readonly torchserve: "machine_learning/torchserve/service_icon";
        readonly training_certification: "customer_enablement/training_certification/service_icon";
        readonly transcribe: "machine_learning/transcribe/service_icon";
        readonly transfer_family: "migration_transfer/transfer_family/service_icon";
        readonly transit_gateway: "networking_content_delivery/transit_gateway/service_icon";
        readonly translate: "machine_learning/translate/service_icon";
        readonly trusted_advisor: "management_governance/trusted_advisor/service_icon";
        readonly vmware_cloud_on_aws: "compute/vmware_cloud_on_aws/service_icon";
        readonly vpc: "networking_content_delivery/vpc/service_icon";
        readonly waf: "security_identity_compliance/waf/service_icon";
        readonly wavelength: "compute/wavelength/service_icon";
        readonly well_architected_tool: "management_governance/well_architected_tool/service_icon";
        readonly workdocs: "business_applications/workdocs/service_icon";
        readonly workdocs_sdk: "business_applications/workdocs_sdk/service_icon";
        readonly worklink: "end_user_computing/worklink/service_icon";
        readonly workmail: "business_applications/workmail/service_icon";
        readonly workspaces: "end_user_computing/workspaces/service_icon";
        readonly workspaces_web: "end_user_computing/workspaces_web/service_icon";
        readonly x_ray: "developer_tools/x_ray/service_icon";
    };
    type Service = keyof typeof Services;
    const Resources: {
        readonly amplify_amplify_studio: "front_end_web_mobile/amplify/amplify_studio";
        readonly api_gateway_endpoint: "application_integration/api_gateway/endpoint";
        readonly app_mesh_mesh: "networking_content_delivery/app_mesh/mesh";
        readonly app_mesh_virtual_gateway: "networking_content_delivery/app_mesh/virtual_gateway";
        readonly app_mesh_virtual_node: "networking_content_delivery/app_mesh/virtual_node";
        readonly app_mesh_virtual_router: "networking_content_delivery/app_mesh/virtual_router";
        readonly app_mesh_virtual_service: "networking_content_delivery/app_mesh/virtual_service";
        readonly backup_backup_plan: "storage/backup/backup_plan";
        readonly backup_backup_restore: "storage/backup/backup_restore";
        readonly backup_backup_support_for_amazon_fsx_for_netapp_ontap: "storage/backup/backup_support_for_amazon_fsx_for_netapp_ontap";
        readonly backup_backup_support_for_amazon_s3: "storage/backup/backup_support_for_amazon_s3";
        readonly backup_backup_support_for_vmware_workloads: "storage/backup/backup_support_for_vmware_workloads";
        readonly backup_backup_vault: "storage/backup/backup_vault";
        readonly backup_compliance_reporting: "storage/backup/compliance_reporting";
        readonly backup_compute: "storage/backup/compute";
        readonly backup_database: "storage/backup/database";
        readonly backup_gateway: "storage/backup/gateway";
        readonly backup_recovery_point_objective: "storage/backup/recovery_point_objective";
        readonly backup_recovery_time_objective: "storage/backup/recovery_time_objective";
        readonly backup_storage: "storage/backup/storage";
        readonly backup_virtual_machine: "storage/backup/virtual_machine";
        readonly backup_virtual_machine_monitor: "storage/backup/virtual_machine_monitor";
        readonly braket_chandelier: "quantum_technologies/braket/chandelier";
        readonly braket_chip: "quantum_technologies/braket/chip";
        readonly braket_embedded_simulator: "quantum_technologies/braket/embedded_simulator";
        readonly braket_managed_simulator: "quantum_technologies/braket/managed_simulator";
        readonly braket_noise_simulator: "quantum_technologies/braket/noise_simulator";
        readonly braket_qpu: "quantum_technologies/braket/qpu";
        readonly braket_simulator: "quantum_technologies/braket/simulator";
        readonly braket_simulator_1: "quantum_technologies/braket/simulator_1";
        readonly braket_simulator_2: "quantum_technologies/braket/simulator_2";
        readonly braket_simulator_3: "quantum_technologies/braket/simulator_3";
        readonly braket_simulator_4: "quantum_technologies/braket/simulator_4";
        readonly braket_state_vector: "quantum_technologies/braket/state_vector";
        readonly braket_tensor_network: "quantum_technologies/braket/tensor_network";
        readonly certificate_manager_certificate_authority: "security_identity_compliance/certificate_manager/certificate_authority";
        readonly cloud9_cloud9: "developer_tools/cloud9/cloud9";
        readonly cloud_map_namespace: "networking_content_delivery/cloud_map/namespace";
        readonly cloud_map_resource: "networking_content_delivery/cloud_map/resource";
        readonly cloud_map_service: "networking_content_delivery/cloud_map/service";
        readonly cloud_wan_core_network_edge: "networking_content_delivery/cloud_wan/core_network_edge";
        readonly cloud_wan_segment_network: "networking_content_delivery/cloud_wan/segment_network";
        readonly cloud_wan_virtual_pop: "networking_content_delivery/cloud_wan/virtual_pop";
        readonly cloudformation_change_set: "management_governance/cloudformation/change_set";
        readonly cloudformation_stack: "management_governance/cloudformation/stack";
        readonly cloudformation_template: "management_governance/cloudformation/template";
        readonly cloudfront_download_distribution: "networking_content_delivery/cloudfront/download_distribution";
        readonly cloudfront_edge_location: "networking_content_delivery/cloudfront/edge_location";
        readonly cloudfront_functions: "networking_content_delivery/cloudfront/functions";
        readonly cloudfront_streaming_distribution: "networking_content_delivery/cloudfront/streaming_distribution";
        readonly cloudsearch_search_documents: "analytics/cloudsearch/search_documents";
        readonly cloudwatch_alarm: "management_governance/cloudwatch/alarm";
        readonly cloudwatch_event_event_based: "management_governance/cloudwatch/event_event_based";
        readonly cloudwatch_event_time_based: "management_governance/cloudwatch/event_time_based";
        readonly cloudwatch_evidently: "management_governance/cloudwatch/evidently";
        readonly cloudwatch_logs: "management_governance/cloudwatch/logs";
        readonly cloudwatch_metrics_insights: "management_governance/cloudwatch/metrics_insights";
        readonly cloudwatch_rule: "management_governance/cloudwatch/rule";
        readonly cloudwatch_rum: "management_governance/cloudwatch/rum";
        readonly cloudwatch_synthetics: "management_governance/cloudwatch/synthetics";
        readonly database_migration_service_database_migration_workflow_job: "database/database_migration_service/database_migration_workflow_job";
        readonly datasync_agent: "migration_transfer/datasync/agent";
        readonly devops_guru_insights: "machine_learning/devops_guru/insights";
        readonly direct_connect_gateway: "networking_content_delivery/direct_connect/gateway";
        readonly directory_service_ad_connector: "security_identity_compliance/directory_service/ad_connector";
        readonly directory_service_managed_microsoft_ad: "security_identity_compliance/directory_service/managed_microsoft_ad";
        readonly directory_service_simple_ad: "security_identity_compliance/directory_service/simple_ad";
        readonly dynamodb_attribute: "database/dynamodb/attribute";
        readonly dynamodb_attributes: "database/dynamodb/attributes";
        readonly dynamodb_dynamodb_accelerator: "database/dynamodb/dynamodb_accelerator";
        readonly dynamodb_global_secondary_index: "database/dynamodb/global_secondary_index";
        readonly dynamodb_item: "database/dynamodb/item";
        readonly dynamodb_items: "database/dynamodb/items";
        readonly dynamodb_standard_access_table_class: "database/dynamodb/standard_access_table_class";
        readonly dynamodb_standard_infrequent_access_table_class: "database/dynamodb/standard_infrequent_access_table_class";
        readonly dynamodb_stream: "database/dynamodb/stream";
        readonly dynamodb_table: "database/dynamodb/table";
        readonly ebs_data_lifecycle_manager: "storage/ebs/data_lifecycle_manager";
        readonly ebs_multiple_volumes: "storage/ebs/multiple_volumes";
        readonly ebs_snapshot: "storage/ebs/snapshot";
        readonly ebs_volume: "storage/ebs/volume";
        readonly ebs_volume_gp3: "storage/ebs/volume_gp3";
        readonly ec2_ami: "compute/ec2/ami";
        readonly ec2_auto_scaling: "compute/ec2/auto_scaling";
        readonly ec2_elastic_ip_address: "compute/ec2/elastic_ip_address";
        readonly ec2_inferentia: "compute/ec2/inferentia";
        readonly ec2_instance: "compute/ec2/instance";
        readonly ec2_instance_with_cloudwatch: "compute/ec2/instance_with_cloudwatch";
        readonly ec2_instances: "compute/ec2/instances";
        readonly ec2_microservice_extractor_for_net: "compute/ec2/microservice_extractor_for_net";
        readonly ec2_rescue: "compute/ec2/rescue";
        readonly ecr_image: "containers/ecr/image";
        readonly ecr_registry: "containers/ecr/registry";
        readonly ecs_container_1: "containers/ecs/container_1";
        readonly ecs_container_2: "containers/ecs/container_2";
        readonly ecs_container_3: "containers/ecs/container_3";
        readonly ecs_copilot_cli: "containers/ecs/copilot_cli";
        readonly ecs_ecs_anywhere: "containers/ecs/ecs_anywhere";
        readonly ecs_service: "containers/ecs/service";
        readonly ecs_task: "containers/ecs/task";
        readonly efs_file_system: "storage/efs/file_system";
        readonly efs_intelligent_tiering: "storage/efs/intelligent_tiering";
        readonly efs_one_zone: "storage/efs/one_zone";
        readonly efs_one_zone_infrequent_access: "storage/efs/one_zone_infrequent_access";
        readonly efs_standard: "storage/efs/standard";
        readonly efs_standard_infrequent_access: "storage/efs/standard_infrequent_access";
        readonly elastic_beanstalk_application: "compute/elastic_beanstalk/application";
        readonly elastic_beanstalk_deployment: "compute/elastic_beanstalk/deployment";
        readonly elastic_load_balancing_application_load_balancer: "networking_content_delivery/elastic_load_balancing/application_load_balancer";
        readonly elastic_load_balancing_classic_load_balancer: "networking_content_delivery/elastic_load_balancing/classic_load_balancer";
        readonly elastic_load_balancing_gateway_load_balancer: "networking_content_delivery/elastic_load_balancing/gateway_load_balancer";
        readonly elastic_load_balancing_network_load_balancer: "networking_content_delivery/elastic_load_balancing/network_load_balancer";
        readonly elasticache_cache_node: "database/elasticache/cache_node";
        readonly elasticache_elasticache_for_memcached: "database/elasticache/elasticache_for_memcached";
        readonly elasticache_elasticache_for_redis: "database/elasticache/elasticache_for_redis";
        readonly emr_cluster: "analytics/emr/cluster";
        readonly emr_emr_engine: "analytics/emr/emr_engine";
        readonly emr_hdfs_cluster: "analytics/emr/hdfs_cluster";
        readonly eventbridge_custom_event_bus: "application_integration/eventbridge/custom_event_bus";
        readonly eventbridge_default_event_bus: "application_integration/eventbridge/default_event_bus";
        readonly eventbridge_event: "application_integration/eventbridge/event";
        readonly eventbridge_rule: "application_integration/eventbridge/rule";
        readonly eventbridge_saas_partner_event: "application_integration/eventbridge/saas_partner_event";
        readonly eventbridge_schema: "application_integration/eventbridge/schema";
        readonly eventbridge_schema_registry: "application_integration/eventbridge/schema_registry";
        readonly glue_crawler: "analytics/glue/crawler";
        readonly glue_data_catalog: "analytics/glue/data_catalog";
        readonly iam_add_on: "security_identity_compliance/iam/add_on";
        readonly iam_data_encryption_key: "security_identity_compliance/iam/data_encryption_key";
        readonly iam_encrypted_data: "security_identity_compliance/iam/encrypted_data";
        readonly iam_iam_access_analyzer: "security_identity_compliance/iam/iam_access_analyzer";
        readonly iam_iam_roles_anywhere: "security_identity_compliance/iam/iam_roles_anywhere";
        readonly iam_long_term_security_credential: "security_identity_compliance/iam/long_term_security_credential";
        readonly iam_mfa_token: "security_identity_compliance/iam/mfa_token";
        readonly iam_permissions: "security_identity_compliance/iam/permissions";
        readonly iam_role: "security_identity_compliance/iam/role";
        readonly iam_sts: "security_identity_compliance/iam/sts";
        readonly iam_sts_alternate: "security_identity_compliance/iam/sts_alternate";
        readonly iam_temporary_security_credential: "security_identity_compliance/iam/temporary_security_credential";
        readonly inspector_agent: "security_identity_compliance/inspector/agent";
        readonly iot_analytics_channel: "internet_of_things/iot_analytics/channel";
        readonly iot_analytics_data_store: "internet_of_things/iot_analytics/data_store";
        readonly iot_analytics_dataset: "internet_of_things/iot_analytics/dataset";
        readonly iot_analytics_notebook: "internet_of_things/iot_analytics/notebook";
        readonly iot_analytics_pipeline: "internet_of_things/iot_analytics/pipeline";
        readonly iot_core_action: "internet_of_things/iot_core/action";
        readonly iot_core_actuator: "internet_of_things/iot_core/actuator";
        readonly iot_core_certificate: "internet_of_things/iot_core/certificate";
        readonly iot_core_desired_state: "internet_of_things/iot_core/desired_state";
        readonly iot_core_device_gateway: "internet_of_things/iot_core/device_gateway";
        readonly iot_core_echo: "internet_of_things/iot_core/echo";
        readonly iot_core_http2_protocol: "internet_of_things/iot_core/http2_protocol";
        readonly iot_core_lorawan_protocol: "internet_of_things/iot_core/lorawan_protocol";
        readonly iot_core_over_air_update: "internet_of_things/iot_core/over_air_update";
        readonly iot_core_policy: "internet_of_things/iot_core/policy";
        readonly iot_core_reported_state: "internet_of_things/iot_core/reported_state";
        readonly iot_core_sailboat: "internet_of_things/iot_core/sailboat";
        readonly iot_core_sensor: "internet_of_things/iot_core/sensor";
        readonly iot_core_servo: "internet_of_things/iot_core/servo";
        readonly iot_core_shadow: "internet_of_things/iot_core/shadow";
        readonly iot_core_simulator: "internet_of_things/iot_core/simulator";
        readonly iot_core_topic: "internet_of_things/iot_core/topic";
        readonly iot_device_defender_iot_device_jobs: "internet_of_things/iot_device_defender/iot_device_jobs";
        readonly iot_device_management_fleet_hub: "internet_of_things/iot_device_management/fleet_hub";
        readonly iot_greengrass_artifact: "internet_of_things/iot_greengrass/artifact";
        readonly iot_greengrass_component: "internet_of_things/iot_greengrass/component";
        readonly iot_greengrass_component_machine_learning: "internet_of_things/iot_greengrass/component_machine_learning";
        readonly iot_greengrass_component_nucleus: "internet_of_things/iot_greengrass/component_nucleus";
        readonly iot_greengrass_component_private: "internet_of_things/iot_greengrass/component_private";
        readonly iot_greengrass_component_public: "internet_of_things/iot_greengrass/component_public";
        readonly iot_greengrass_connector: "internet_of_things/iot_greengrass/connector";
        readonly iot_greengrass_interprocess_communication: "internet_of_things/iot_greengrass/interprocess_communication";
        readonly iot_greengrass_protocol: "internet_of_things/iot_greengrass/protocol";
        readonly iot_greengrass_recipe: "internet_of_things/iot_greengrass/recipe";
        readonly iot_greengrass_stream_manager: "internet_of_things/iot_greengrass/stream_manager";
        readonly iot_http_protocol: "internet_of_things/iot_http/protocol";
        readonly iot_mqtt_protocol: "internet_of_things/iot_mqtt/protocol";
        readonly iot_sitewise_asset: "internet_of_things/iot_sitewise/asset";
        readonly iot_sitewise_asset_hierarchy: "internet_of_things/iot_sitewise/asset_hierarchy";
        readonly iot_sitewise_asset_model: "internet_of_things/iot_sitewise/asset_model";
        readonly iot_sitewise_asset_properties: "internet_of_things/iot_sitewise/asset_properties";
        readonly iot_sitewise_data_streams: "internet_of_things/iot_sitewise/data_streams";
        readonly lake_formation_data_lake: "analytics/lake_formation/data_lake";
        readonly lambda_lambda_function: "compute/lambda/lambda_function";
        readonly license_manager_application_discovery: "management_governance/license_manager/application_discovery";
        readonly license_manager_license_blending: "management_governance/license_manager/license_blending";
        readonly location_service_geofence: "front_end_web_mobile/location_service/geofence";
        readonly location_service_map: "front_end_web_mobile/location_service/map";
        readonly location_service_place: "front_end_web_mobile/location_service/place";
        readonly location_service_routes: "front_end_web_mobile/location_service/routes";
        readonly location_service_track: "front_end_web_mobile/location_service/track";
        readonly mainframe_modernization_analyzer: "migration_transfer/mainframe_modernization/analyzer";
        readonly mainframe_modernization_compiler: "migration_transfer/mainframe_modernization/compiler";
        readonly mainframe_modernization_converter: "migration_transfer/mainframe_modernization/converter";
        readonly mainframe_modernization_developer: "migration_transfer/mainframe_modernization/developer";
        readonly mainframe_modernization_runtime: "migration_transfer/mainframe_modernization/runtime";
        readonly managed_blockchain_blockchain: "blockchain/managed_blockchain/blockchain";
        readonly migration_hub_refactor_spaces_applications: "migration_transfer/migration_hub/refactor_spaces_applications";
        readonly migration_hub_refactor_spaces_environments: "migration_transfer/migration_hub/refactor_spaces_environments";
        readonly migration_hub_refactor_spaces_services: "migration_transfer/migration_hub/refactor_spaces_services";
        readonly mq_broker: "application_integration/mq/broker";
        readonly msk_msk_connect: "analytics/msk/msk_connect";
        readonly network_firewall_endpoints: "security_identity_compliance/network_firewall/endpoints";
        readonly opsworks_apps: "management_governance/opsworks/apps";
        readonly opsworks_deployments: "management_governance/opsworks/deployments";
        readonly opsworks_instances: "management_governance/opsworks/instances";
        readonly opsworks_layers: "management_governance/opsworks/layers";
        readonly opsworks_monitoring: "management_governance/opsworks/monitoring";
        readonly opsworks_permissions: "management_governance/opsworks/permissions";
        readonly opsworks_resources: "management_governance/opsworks/resources";
        readonly opsworks_stack2: "management_governance/opsworks/stack2";
        readonly organizations_account: "management_governance/organizations/account";
        readonly organizations_management_account: "management_governance/organizations/management_account";
        readonly organizations_organizational_unit: "management_governance/organizations/organizational_unit";
        readonly pinpoint_journey: "business_applications/pinpoint/journey";
        readonly rds_instance: "database/rds/instance";
        readonly rds_multi_az: "database/rds/multi_az";
        readonly rds_multi_az_db_cluster: "database/rds/multi_az_db_cluster";
        readonly redshift_dense_compute_node: "analytics/redshift/dense_compute_node";
        readonly redshift_dense_storage_node: "analytics/redshift/dense_storage_node";
        readonly redshift_ml: "analytics/redshift/ml";
        readonly redshift_ra3: "analytics/redshift/ra3";
        readonly rekognition_image: "machine_learning/rekognition/image";
        readonly rekognition_video: "machine_learning/rekognition/video";
        readonly robomaker_cloud_extensions_ros: "robotics/robomaker/cloud_extensions_ros";
        readonly robomaker_development_environment: "robotics/robomaker/development_environment";
        readonly robomaker_fleet_management: "robotics/robomaker/fleet_management";
        readonly robomaker_simulation: "robotics/robomaker/simulation";
        readonly route_53_application_recovery_controller: "networking_content_delivery/route_53/application_recovery_controller";
        readonly route_53_hosted_zone: "networking_content_delivery/route_53/hosted_zone";
        readonly route_53_readiness_checks: "networking_content_delivery/route_53/readiness_checks";
        readonly route_53_resolver: "networking_content_delivery/route_53/resolver";
        readonly route_53_resolver_dns_firewall: "networking_content_delivery/route_53/resolver_dns_firewall";
        readonly route_53_resolver_query_logging: "networking_content_delivery/route_53/resolver_query_logging";
        readonly route_53_route_table: "networking_content_delivery/route_53/route_table";
        readonly route_53_routing_controls: "networking_content_delivery/route_53/routing_controls";
        readonly s3_bucket: "storage/s3/bucket";
        readonly s3_bucket_with_objects: "storage/s3/bucket_with_objects";
        readonly s3_general_access_points: "storage/s3/general_access_points";
        readonly s3_glacier_archive: "storage/s3_glacier/archive";
        readonly s3_glacier_deep_archive: "storage/s3_glacier/deep_archive";
        readonly s3_glacier_flexible_retrieval: "storage/s3_glacier/flexible_retrieval";
        readonly s3_glacier_instant_retrieval: "storage/s3_glacier/instant_retrieval";
        readonly s3_glacier_vault: "storage/s3_glacier/vault";
        readonly s3_object: "storage/s3/object";
        readonly s3_s3_intelligent_tiering: "storage/s3/s3_intelligent_tiering";
        readonly s3_s3_object_lambda: "storage/s3/s3_object_lambda";
        readonly s3_s3_object_lambda_access_points: "storage/s3/s3_object_lambda_access_points";
        readonly s3_s3_on_outposts: "storage/s3/s3_on_outposts";
        readonly s3_s3_one_zone_ia: "storage/s3/s3_one_zone_ia";
        readonly s3_s3_replication: "storage/s3/s3_replication";
        readonly s3_s3_replication_time_control: "storage/s3/s3_replication_time_control";
        readonly s3_s3_standard: "storage/s3/s3_standard";
        readonly s3_s3_standard_ia: "storage/s3/s3_standard_ia";
        readonly s3_s3_storage_lens: "storage/s3/s3_storage_lens";
        readonly s3_vpc_access_points: "storage/s3/vpc_access_points";
        readonly sagemaker_canvas: "machine_learning/sagemaker/canvas";
        readonly sagemaker_model: "machine_learning/sagemaker/model";
        readonly sagemaker_notebook: "machine_learning/sagemaker/notebook";
        readonly sagemaker_train: "machine_learning/sagemaker/train";
        readonly security_hub_finding: "security_identity_compliance/security_hub/finding";
        readonly ses_email: "business_applications/ses/email";
        readonly shield_shield_advanced: "security_identity_compliance/shield/shield_advanced";
        readonly snowball_snowball_import_export: "storage/snowball/snowball_import_export";
        readonly sns_email_notification: "application_integration/sns/email_notification";
        readonly sns_http_notification: "application_integration/sns/http_notification";
        readonly sns_topic: "application_integration/sns/topic";
        readonly sqs_message: "application_integration/sqs/message";
        readonly sqs_queue: "application_integration/sqs/queue";
        readonly ssm_automation: "management_governance/ssm/automation";
        readonly ssm_change_calendar: "management_governance/ssm/change_calendar";
        readonly ssm_change_manager: "management_governance/ssm/change_manager";
        readonly ssm_compliance: "management_governance/ssm/compliance";
        readonly ssm_documents: "management_governance/ssm/documents";
        readonly ssm_inventory: "management_governance/ssm/inventory";
        readonly ssm_maintenance_windows: "management_governance/ssm/maintenance_windows";
        readonly ssm_opscenter: "management_governance/ssm/opscenter";
        readonly ssm_parameter_store: "management_governance/ssm/parameter_store";
        readonly ssm_patch_manager: "management_governance/ssm/patch_manager";
        readonly ssm_run_command: "management_governance/ssm/run_command";
        readonly ssm_session_manager: "management_governance/ssm/session_manager";
        readonly ssm_state_manager: "management_governance/ssm/state_manager";
        readonly storage_gateway_cached_volume: "storage/storage_gateway/cached_volume";
        readonly storage_gateway_file_gateway: "storage/storage_gateway/file_gateway";
        readonly storage_gateway_fsx_file_gateway: "storage/storage_gateway/fsx_file_gateway";
        readonly storage_gateway_noncached_volume: "storage/storage_gateway/noncached_volume";
        readonly storage_gateway_s3_file_gateway: "storage/storage_gateway/s3_file_gateway";
        readonly storage_gateway_tape_gateway: "storage/storage_gateway/tape_gateway";
        readonly storage_gateway_virtual_tape_library: "storage/storage_gateway/virtual_tape_library";
        readonly storage_gateway_volume_gateway: "storage/storage_gateway/volume_gateway";
        readonly transfer_family_ftp: "migration_transfer/transfer_family/ftp";
        readonly transfer_family_ftps: "migration_transfer/transfer_family/ftps";
        readonly transfer_family_sftp: "migration_transfer/transfer_family/sftp";
        readonly transit_gateway_attachment: "networking_content_delivery/transit_gateway/attachment";
        readonly trusted_advisor_checklist: "management_governance/trusted_advisor/checklist";
        readonly trusted_advisor_checklist_cost: "management_governance/trusted_advisor/checklist_cost";
        readonly trusted_advisor_checklist_fault_tolerant: "management_governance/trusted_advisor/checklist_fault_tolerant";
        readonly trusted_advisor_checklist_performance: "management_governance/trusted_advisor/checklist_performance";
        readonly trusted_advisor_checklist_security: "management_governance/trusted_advisor/checklist_security";
        readonly vpc_carrier_gateway: "networking_content_delivery/vpc/carrier_gateway";
        readonly vpc_customer_gateway: "networking_content_delivery/vpc/customer_gateway";
        readonly vpc_elastic_network_adapter: "networking_content_delivery/vpc/elastic_network_adapter";
        readonly vpc_elastic_network_interface: "networking_content_delivery/vpc/elastic_network_interface";
        readonly vpc_endpoints: "networking_content_delivery/vpc/endpoints";
        readonly vpc_flow_logs: "networking_content_delivery/vpc/flow_logs";
        readonly vpc_internet_gateway: "networking_content_delivery/vpc/internet_gateway";
        readonly vpc_nat_gateway: "networking_content_delivery/vpc/nat_gateway";
        readonly vpc_network_access_analyzer: "networking_content_delivery/vpc/network_access_analyzer";
        readonly vpc_network_access_control_list: "networking_content_delivery/vpc/network_access_control_list";
        readonly vpc_peering_connection: "networking_content_delivery/vpc/peering_connection";
        readonly vpc_reachability_analyzer: "networking_content_delivery/vpc/reachability_analyzer";
        readonly vpc_router: "networking_content_delivery/vpc/router";
        readonly vpc_traffic_mirroring: "networking_content_delivery/vpc/traffic_mirroring";
        readonly vpc_vpn_connection: "networking_content_delivery/vpc/vpn_connection";
        readonly vpc_vpn_gateway: "networking_content_delivery/vpc/vpn_gateway";
        readonly waf_bad_bot: "security_identity_compliance/waf/bad_bot";
        readonly waf_bot: "security_identity_compliance/waf/bot";
        readonly waf_bot_control: "security_identity_compliance/waf/bot_control";
        readonly waf_filtering_rule: "security_identity_compliance/waf/filtering_rule";
        readonly waf_labels: "security_identity_compliance/waf/labels";
        readonly waf_managed_rule: "security_identity_compliance/waf/managed_rule";
        readonly waf_rule: "security_identity_compliance/waf/rule";
    };
    type Resource = keyof typeof Resources;
    const InstanceTypes: {
        readonly a1: "compute/ec2/instance/a1";
        readonly c4: "compute/ec2/instance/c4";
        readonly c5: "compute/ec2/instance/c5";
        readonly c5a: "compute/ec2/instance/c5a";
        readonly c5ad: "compute/ec2/instance/c5ad";
        readonly c5d: "compute/ec2/instance/c5d";
        readonly c5n: "compute/ec2/instance/c5n";
        readonly c6a: "compute/ec2/instance/c6a";
        readonly c6g: "compute/ec2/instance/c6g";
        readonly c6gd: "compute/ec2/instance/c6gd";
        readonly c6gn: "compute/ec2/instance/c6gn";
        readonly c6i: "compute/ec2/instance/c6i";
        readonly c7g: "compute/ec2/instance/c7g";
        readonly d2: "compute/ec2/instance/d2";
        readonly d3: "compute/ec2/instance/d3";
        readonly d3en: "compute/ec2/instance/d3en";
        readonly db: "compute/ec2/instance/db";
        readonly dl1: "compute/ec2/instance/dl1";
        readonly f1: "compute/ec2/instance/f1";
        readonly g3: "compute/ec2/instance/g3";
        readonly g4ad: "compute/ec2/instance/g4ad";
        readonly g4dn: "compute/ec2/instance/g4dn";
        readonly g5: "compute/ec2/instance/g5";
        readonly g5g: "compute/ec2/instance/g5g";
        readonly h1: "compute/ec2/instance/h1";
        readonly habana_gaudi: "compute/ec2/instance/habana_gaudi";
        readonly hmi: "compute/ec2/instance/hmi";
        readonly hpc6a: "compute/ec2/instance/hpc6a";
        readonly i2: "compute/ec2/instance/i2";
        readonly i3: "compute/ec2/instance/i3";
        readonly i3en: "compute/ec2/instance/i3en";
        readonly i4i: "compute/ec2/instance/i4i";
        readonly im4gn: "compute/ec2/instance/im4gn";
        readonly inf1: "compute/ec2/instance/inf1";
        readonly is4gen: "compute/ec2/instance/is4gen";
        readonly m1_mac: "compute/ec2/instance/m1_mac";
        readonly m4: "compute/ec2/instance/m4";
        readonly m5: "compute/ec2/instance/m5";
        readonly m5a: "compute/ec2/instance/m5a";
        readonly m5d: "compute/ec2/instance/m5d";
        readonly m5dn: "compute/ec2/instance/m5dn";
        readonly m5n: "compute/ec2/instance/m5n";
        readonly m5zn: "compute/ec2/instance/m5zn";
        readonly m6a: "compute/ec2/instance/m6a";
        readonly m6g: "compute/ec2/instance/m6g";
        readonly m6gd: "compute/ec2/instance/m6gd";
        readonly m6i: "compute/ec2/instance/m6i";
        readonly mac: "compute/ec2/instance/mac";
        readonly p2: "compute/ec2/instance/p2";
        readonly p3: "compute/ec2/instance/p3";
        readonly p3dn: "compute/ec2/instance/p3dn";
        readonly p4: "compute/ec2/instance/p4";
        readonly p4d: "compute/ec2/instance/p4d";
        readonly p4de: "compute/ec2/instance/p4de";
        readonly r4: "compute/ec2/instance/r4";
        readonly r5: "compute/ec2/instance/r5";
        readonly r5a: "compute/ec2/instance/r5a";
        readonly r5ad: "compute/ec2/instance/r5ad";
        readonly r5b: "compute/ec2/instance/r5b";
        readonly r5d: "compute/ec2/instance/r5d";
        readonly r5gd: "compute/ec2/instance/r5gd";
        readonly r5n: "compute/ec2/instance/r5n";
        readonly r6g: "compute/ec2/instance/r6g";
        readonly r6i: "compute/ec2/instance/r6i";
        readonly rdn: "compute/ec2/instance/rdn";
        readonly spot: "compute/ec2/instance/spot";
        readonly t2: "compute/ec2/instance/t2";
        readonly t3: "compute/ec2/instance/t3";
        readonly t3a: "compute/ec2/instance/t3a";
        readonly t4g: "compute/ec2/instance/t4g";
        readonly trainium: "compute/ec2/instance/trainium";
        readonly trn1: "compute/ec2/instance/trn1";
        readonly vt1: "compute/ec2/instance/vt1";
        readonly x1: "compute/ec2/instance/x1";
        readonly x1e: "compute/ec2/instance/x1e";
        readonly x2gd: "compute/ec2/instance/x2gd";
        readonly x2idn: "compute/ec2/instance/x2idn";
        readonly x2iedn: "compute/ec2/instance/x2iedn";
        readonly x2iezn: "compute/ec2/instance/x2iezn";
        readonly z1d: "compute/ec2/instance/z1d";
    };
    type InstanceType = keyof typeof InstanceTypes;
    const RdsInstanceTypes: {
        readonly aurora: "database/rds/instance/aurora";
        readonly aurora_alt: "database/rds/instance/aurora_alt";
        readonly mariadb: "database/rds/instance/mariadb";
        readonly mariadb_alt: "database/rds/instance/mariadb_alt";
        readonly mysql: "database/rds/instance/mysql";
        readonly mysql_alt: "database/rds/instance/mysql_alt";
        readonly oracle: "database/rds/instance/oracle";
        readonly oracle_alt: "database/rds/instance/oracle_alt";
        readonly piops: "database/rds/instance/piops";
        readonly postgresql: "database/rds/instance/postgresql";
        readonly postgresql_alt: "database/rds/instance/postgresql_alt";
        readonly proxy: "database/rds/instance/proxy";
        readonly proxy_alt: "database/rds/instance/proxy_alt";
        readonly sqlserver: "database/rds/instance/sqlserver";
        readonly sqlserver_alt: "database/rds/instance/sqlserver_alt";
    };
    type RdsInstanceType = keyof typeof RdsInstanceTypes;
    const IotThings: {
        readonly bank: "internet_of_things/thing/bank";
        readonly bicycle: "internet_of_things/thing/bicycle";
        readonly camera: "internet_of_things/thing/camera";
        readonly car: "internet_of_things/thing/car";
        readonly cart: "internet_of_things/thing/cart";
        readonly coffee_pot: "internet_of_things/thing/coffee_pot";
        readonly door_lock: "internet_of_things/thing/door_lock";
        readonly factory: "internet_of_things/thing/factory";
        readonly generic: "internet_of_things/thing/generic";
        readonly house: "internet_of_things/thing/house";
        readonly lightbulb: "internet_of_things/thing/lightbulb";
        readonly medical_emergency: "internet_of_things/thing/medical_emergency";
        readonly police_emergency: "internet_of_things/thing/police_emergency";
        readonly thermostat: "internet_of_things/thing/thermostat";
        readonly travel: "internet_of_things/thing/travel";
        readonly utility: "internet_of_things/thing/utility";
        readonly windfarm: "internet_of_things/thing/windfarm";
    };
    type IotThing = keyof typeof IotThings;
    const GeneralIcons: {
        readonly acl: "networking_content_delivery/vpc/network_access_control_list";
        readonly alarm: "management_governance/cloudwatch/alarm";
        readonly alert: "general/alert";
        readonly attachment: "networking_content_delivery/transit_gateway/attachment";
        readonly camera: "general/camera";
        readonly chat: "general/chat";
        readonly client: "general/client";
        readonly config: "general/gear";
        readonly configuration: "general/gear";
        readonly credentials_long: "security_identity_compliance/iam/long_term_security_credential";
        readonly credentials_temp: "security_identity_compliance/iam/temporary_security_credential";
        readonly disk: "general/disk";
        readonly document: "general/document";
        readonly documents: "general/documents";
        readonly email: "general/email";
        readonly encrypted_data: "security_identity_compliance/iam/encrypted_data";
        readonly eni: "networking_content_delivery/vpc/elastic_network_interface";
        readonly event: "management_governance/cloudwatch/event_event_based";
        readonly firewall: "general/firewall";
        readonly folder: "general/folder";
        readonly folders: "general/folders";
        readonly forums: "general/forums";
        readonly gear: "general/gear";
        readonly generic_application: "general/generic_application";
        readonly generic_database: "general/generic_database";
        readonly git_repository: "general/git_repository";
        readonly globe: "general/globe";
        readonly interactive_video: "general/multimedia";
        readonly internet: "general/internet";
        readonly internet_alt1: "general/internet_alt1";
        readonly internet_alt2: "general/internet_alt2";
        readonly key: "security_identity_compliance/iam/permissions";
        readonly logs: "management_governance/cloudwatch/logs";
        readonly magnifying_glass: "general/magnifying_glass";
        readonly management_console: "general/management_console";
        readonly marketplace: "general/marketplace";
        readonly mobile_client: "general/mobile_client";
        readonly multimedia: "general/multimedia";
        readonly office_building: "general/office_building";
        readonly policy: "security_identity_compliance/iam/add_on";
        readonly question: "general/question";
        readonly recover: "general/recover";
        readonly role: "security_identity_compliance/iam/role";
        readonly rule: "management_governance/cloudwatch/rule";
        readonly saml_token: "general/saml_token";
        readonly scheduled_event: "management_governance/cloudwatch/event_time_based";
        readonly sdk: "general/sdk";
        readonly servers: "general/servers";
        readonly shield: "general/shield";
        readonly source_code: "general/source_code";
        readonly ssl_padlock: "general/ssl_padlock";
        readonly tape_storage: "general/tape_storage";
        readonly template: "management_governance/cloudformation/template";
        readonly toolkit: "general/toolkit";
        readonly traditional_server: "general/traditional_server";
        readonly user: "general/user";
        readonly users: "general/users";
    };
    type GeneralIcon = keyof typeof GeneralIcons;
    const Groups: {
        readonly account: "groups/account";
        readonly auto_scaling_group: "groups/auto_scaling_group";
        readonly aws_cloud: "groups/aws_cloud";
        readonly aws_cloud_alt: "groups/aws_cloud_alt";
        readonly aws_step_functions_workflow: "groups/aws_step_functions_workflow";
        readonly corporate_data_center: "groups/corporate_data_center";
        readonly ec2_instance_contents: "groups/ec2_instance_contents";
        readonly elastic_beanstalk: "groups/elastic_beanstalk";
        readonly iot_greengrass: "groups/iot_greengrass";
        readonly iot_greengrass_deployment: "groups/iot_greengrass_deployment";
        readonly on_premise: "groups/on_premise";
        readonly region: "groups/region";
        readonly spot_fleet: "groups/spot_fleet";
        readonly subnet_private: "groups/subnet_private";
        readonly subnet_public: "groups/subnet_public";
        readonly vpc: "groups/vpc";
    };
    type Group = keyof typeof Groups;
    const AssetFullNameLookup: {
        readonly activate: "AWS Activate";
        readonly alexa_for_business: "Alexa For Business";
        readonly amplify: "AWS Amplify";
        readonly amplify_amplify_studio: "AWS Amplify Studio";
        readonly analytics: "Analytics";
        readonly apache_mxnet_on_aws: "Apache MXNet on AWS";
        readonly api_gateway: "Amazon API Gateway";
        readonly api_gateway_endpoint: "Endpoint";
        readonly app_mesh: "AWS App Mesh";
        readonly app_mesh_mesh: "Mesh";
        readonly app_mesh_virtual_gateway: "Virtual Gateway";
        readonly app_mesh_virtual_node: "Virtual Node";
        readonly app_mesh_virtual_router: "Virtual Router";
        readonly app_mesh_virtual_service: "Virtual Service";
        readonly app_runner: "AWS App Runner";
        readonly appconfig: "AWS AppConfig";
        readonly appflow: "Amazon AppFlow";
        readonly application_auto_scaling: "AWS Application Auto Scaling";
        readonly application_cost_profiler: "AWS Application Cost Profiler";
        readonly application_discovery_service: "AWS Application Discovery Service";
        readonly application_integration: "Application Integration";
        readonly application_migration_service: "AWS Application Migration Service";
        readonly appstream: "Amazon AppStream";
        readonly appsync: "AWS AppSync";
        readonly aps: "Amazon Managed Service for Prometheus";
        readonly artifact: "AWS Artifact";
        readonly athena: "Amazon Athena";
        readonly audit_manager: "AWS Audit Manager";
        readonly augmented_ai_a2i: "Amazon Augmented AI A2I";
        readonly aurora: "Amazon Aurora";
        readonly auto_scaling: "AWS Auto Scaling";
        readonly backint_agent: "AWS Backint Agent";
        readonly backup: "AWS Backup";
        readonly backup_backup_plan: "Backup Plan";
        readonly backup_backup_restore: "Backup Restore";
        readonly backup_backup_support_for_amazon_fsx_for_netapp_ontap: "AWS Backup support for Amazon FSx for NetApp ONTAP";
        readonly backup_backup_support_for_amazon_s3: "AWS Backup support for Amazon S3";
        readonly backup_backup_support_for_vmware_workloads: "AWS Backup support for VMware Workloads";
        readonly backup_backup_vault: "Backup Vault";
        readonly backup_compliance_reporting: "Compliance Reporting";
        readonly backup_compute: "Compute";
        readonly backup_database: "Database";
        readonly backup_gateway: "Gateway";
        readonly backup_recovery_point_objective: "Recovery Point Objective";
        readonly backup_recovery_time_objective: "Recovery Time Objective";
        readonly backup_storage: "Storage";
        readonly backup_virtual_machine: "Virtual Machine";
        readonly backup_virtual_machine_monitor: "Virtual Machine Monitor";
        readonly batch: "AWS Batch";
        readonly billing_conductor: "AWS Billing Conductor";
        readonly blockchain: "Blockchain";
        readonly bottlerocket: "Bottlerocket";
        readonly braket: "Amazon Braket";
        readonly braket_chandelier: "Chandelier";
        readonly braket_chip: "Chip";
        readonly braket_embedded_simulator: "Embedded Simulator";
        readonly braket_managed_simulator: "Managed Simulator";
        readonly braket_noise_simulator: "Noise Simulator";
        readonly braket_qpu: "QPU";
        readonly braket_simulator: "Simulator";
        readonly braket_simulator_1: "Simulator 1";
        readonly braket_simulator_2: "Simulator 2";
        readonly braket_simulator_3: "Simulator 3";
        readonly braket_simulator_4: "Simulator 4";
        readonly braket_state_vector: "State Vector";
        readonly braket_tensor_network: "Tensor Network";
        readonly budgets: "AWS Budgets";
        readonly business_applications: "Business Applications";
        readonly certificate_manager: "AWS Certificate Manager";
        readonly certificate_manager_certificate_authority: "Certificate Authority";
        readonly chatbot: "AWS Chatbot";
        readonly chime: "Amazon Chime";
        readonly chime_sdk: "Amazon Chime SDK";
        readonly chime_voice_connector: "Amazon Chime Voice Connector";
        readonly client_vpn: "AWS Client VPN";
        readonly cloud9: "AWS Cloud9";
        readonly cloud9_cloud9: "Cloud9";
        readonly cloud_control_api: "AWS Cloud Control API";
        readonly cloud_development_kit: "AWS Cloud Development Kit";
        readonly cloud_directory: "Amazon Cloud Directory";
        readonly cloud_financial_management: "Cloud Financial Management";
        readonly cloud_map: "AWS Cloud Map";
        readonly cloud_map_namespace: "Namespace";
        readonly cloud_map_resource: "Resource";
        readonly cloud_map_service: "Service";
        readonly cloud_wan: "AWS Cloud WAN";
        readonly cloud_wan_core_network_edge: "Core Network Edge";
        readonly cloud_wan_segment_network: "Segment Network";
        readonly cloud_wan_virtual_pop: "Virtual PoP";
        readonly cloudendure_disaster_recovery: "CloudEndure Disaster Recovery";
        readonly cloudformation: "AWS CloudFormation";
        readonly cloudformation_change_set: "Change Set";
        readonly cloudformation_stack: "Stack";
        readonly cloudformation_template: "Template";
        readonly cloudfront: "Amazon CloudFront";
        readonly cloudfront_download_distribution: "Download Distribution";
        readonly cloudfront_edge_location: "Edge Location";
        readonly cloudfront_functions: "Functions";
        readonly cloudfront_streaming_distribution: "Streaming Distribution";
        readonly cloudhsm: "AWS CloudHSM";
        readonly cloudsearch: "Amazon CloudSearch";
        readonly cloudsearch_search_documents: "Search Documents";
        readonly cloudshell: "AWS CloudShell";
        readonly cloudtrail: "AWS CloudTrail";
        readonly cloudwatch: "Amazon CloudWatch";
        readonly cloudwatch_alarm: "Alarm";
        readonly cloudwatch_event_event_based: "Event Event Based";
        readonly cloudwatch_event_time_based: "Event Time Based";
        readonly cloudwatch_evidently: "Evidently";
        readonly cloudwatch_logs: "Logs";
        readonly cloudwatch_metrics_insights: "Metrics Insights";
        readonly cloudwatch_rule: "Rule";
        readonly cloudwatch_rum: "RUM";
        readonly cloudwatch_synthetics: "Synthetics";
        readonly codeartifact: "AWS CodeArtifact";
        readonly codebuild: "AWS CodeBuild";
        readonly codecommit: "AWS CodeCommit";
        readonly codedeploy: "AWS CodeDeploy";
        readonly codeguru: "Amazon CodeGuru";
        readonly codepipeline: "AWS CodePipeline";
        readonly codestar: "AWS CodeStar";
        readonly codewhisperer: "Amazon CodeWhisperer";
        readonly cognito: "Amazon Cognito";
        readonly command_line_interface: "AWS Command Line Interface";
        readonly comprehend: "Amazon Comprehend";
        readonly comprehend_medical: "Amazon Comprehend Medical";
        readonly compute: "Compute";
        readonly compute_optimizer: "AWS Compute Optimizer";
        readonly config: "AWS Config";
        readonly connect: "Amazon Connect";
        readonly console_mobile_application: "AWS Console Mobile Application";
        readonly containers: "Containers";
        readonly control_tower: "AWS Control Tower";
        readonly corretto: "Amazon Corretto";
        readonly cost_and_usage_report: "AWS Cost and Usage Report";
        readonly cost_explorer: "AWS Cost Explorer";
        readonly customer_enablement: "Customer Enablement";
        readonly data_exchange: "AWS Data Exchange";
        readonly data_pipeline: "AWS Data Pipeline";
        readonly database: "Database";
        readonly database_migration_service: "AWS Database Migration Service";
        readonly database_migration_service_database_migration_workflow_job: "Database migration workflow job";
        readonly datasync: "AWS DataSync";
        readonly datasync_agent: "Agent";
        readonly deep_learning_amis: "AWS Deep Learning AMIs";
        readonly deep_learning_containers: "AWS Deep Learning Containers";
        readonly deepcomposer: "AWS DeepComposer";
        readonly deeplens: "AWS DeepLens";
        readonly deepracer: "AWS DeepRacer";
        readonly detective: "Amazon Detective";
        readonly developer_tools: "Developer Tools";
        readonly device_farm: "AWS Device Farm";
        readonly devops_guru: "Amazon DevOps Guru";
        readonly devops_guru_insights: "Insights";
        readonly direct_connect: "AWS Direct Connect";
        readonly direct_connect_gateway: "Gateway";
        readonly directory_service: "AWS Directory Service";
        readonly directory_service_ad_connector: "AD Connector";
        readonly directory_service_managed_microsoft_ad: "AWS Managed Microsoft AD";
        readonly directory_service_simple_ad: "Simple AD";
        readonly distro_for_opentelemetry: "AWS Distro for OpenTelemetry";
        readonly documentdb: "Amazon DocumentDB";
        readonly dynamodb: "Amazon DynamoDB";
        readonly dynamodb_attribute: "Attribute";
        readonly dynamodb_attributes: "Attributes";
        readonly dynamodb_dynamodb_accelerator: "Amazon DynamoDB Accelerator";
        readonly dynamodb_global_secondary_index: "Global secondary index";
        readonly dynamodb_item: "Item";
        readonly dynamodb_items: "Items";
        readonly dynamodb_standard_access_table_class: "Standard Access Table Class";
        readonly dynamodb_standard_infrequent_access_table_class: "Standard Infrequent Access Table Class";
        readonly dynamodb_stream: "Stream";
        readonly dynamodb_table: "Table";
        readonly ebs: "Amazon Elastic Block Store";
        readonly ebs_data_lifecycle_manager: "Amazon Data Lifecycle Manager";
        readonly ebs_multiple_volumes: "Multiple Volumes";
        readonly ebs_snapshot: "Snapshot";
        readonly ebs_volume: "Volume";
        readonly ebs_volume_gp3: "Volume gp3";
        readonly ec2: "Amazon EC2";
        readonly ec2_ami: "AMI";
        readonly ec2_auto_scaling: "Auto Scaling";
        readonly ec2_elastic_ip_address: "Elastic IP Address";
        readonly ec2_image_builder: "Amazon EC2 Image Builder";
        readonly ec2_inferentia: "AWS Inferentia";
        readonly ec2_instance: "Instance";
        readonly ec2_instance_with_cloudwatch: "Instance with CloudWatch";
        readonly ec2_instances: "Instances";
        readonly ec2_microservice_extractor_for_net: "AWS Microservice Extractor for .NET";
        readonly ec2_rescue: "Rescue";
        readonly ecr: "Amazon Elastic Container Registry";
        readonly ecr_image: "Image";
        readonly ecr_registry: "Registry";
        readonly ecs: "Amazon Elastic Container Service";
        readonly ecs_anywhere: "Amazon ECS Anywhere";
        readonly ecs_container_1: "Container 1";
        readonly ecs_container_2: "Container 2";
        readonly ecs_container_3: "Container 3";
        readonly ecs_copilot_cli: "Copilot CLI";
        readonly ecs_ecs_anywhere: "ECS Anywhere";
        readonly ecs_service: "Service";
        readonly ecs_task: "Task";
        readonly efs: "Amazon EFS";
        readonly efs_file_system: "File System";
        readonly efs_intelligent_tiering: "Intelligent Tiering";
        readonly efs_one_zone: "One Zone";
        readonly efs_one_zone_infrequent_access: "One Zone Infrequent Access";
        readonly efs_standard: "Standard";
        readonly efs_standard_infrequent_access: "Standard Infrequent Access";
        readonly eks: "Amazon Elastic Kubernetes Service";
        readonly eks_anywhere: "Amazon EKS Anywhere";
        readonly eks_cloud: "Amazon EKS Cloud";
        readonly eks_distro: "Amazon EKS Distro";
        readonly elastic_beanstalk: "AWS Elastic Beanstalk";
        readonly elastic_beanstalk_application: "Application";
        readonly elastic_beanstalk_deployment: "Deployment";
        readonly elastic_fabric_adapter: "Elastic Fabric Adapter";
        readonly elastic_inference: "Amazon Elastic Inference";
        readonly elastic_load_balancing: "Elastic Load Balancing";
        readonly elastic_load_balancing_application_load_balancer: "Application Load Balancer";
        readonly elastic_load_balancing_classic_load_balancer: "Classic Load Balancer";
        readonly elastic_load_balancing_gateway_load_balancer: "Gateway Load Balancer";
        readonly elastic_load_balancing_network_load_balancer: "Network Load Balancer";
        readonly elastic_transcoder: "Amazon Elastic Transcoder";
        readonly elasticache: "Amazon ElastiCache";
        readonly elasticache_cache_node: "Cache Node";
        readonly elasticache_elasticache_for_memcached: "ElastiCache for Memcached";
        readonly elasticache_elasticache_for_redis: "ElastiCache for Redis";
        readonly elemental_appliances_software: "AWS Elemental Appliances & Software";
        readonly elemental_conductor: "AWS Elemental Conductor";
        readonly elemental_delta: "AWS Elemental Delta";
        readonly elemental_link: "AWS Elemental Link";
        readonly elemental_live: "AWS Elemental Live";
        readonly elemental_mediaconnect: "AWS Elemental MediaConnect";
        readonly elemental_mediaconvert: "AWS Elemental MediaConvert";
        readonly elemental_medialive: "AWS Elemental MediaLive";
        readonly elemental_mediapackage: "AWS Elemental MediaPackage";
        readonly elemental_mediastore: "AWS Elemental MediaStore";
        readonly elemental_mediatailor: "AWS Elemental MediaTailor";
        readonly elemental_server: "AWS Elemental Server";
        readonly emr: "Amazon EMR";
        readonly emr_cluster: "Cluster";
        readonly emr_emr_engine: "EMR Engine";
        readonly emr_hdfs_cluster: "HDFS Cluster";
        readonly end_user_computing: "End User Computing";
        readonly eventbridge: "Amazon EventBridge";
        readonly eventbridge_custom_event_bus: "Custom Event Bus";
        readonly eventbridge_default_event_bus: "Default Event Bus";
        readonly eventbridge_event: "Event";
        readonly eventbridge_rule: "Rule";
        readonly eventbridge_saas_partner_event: "Saas Partner Event";
        readonly eventbridge_schema: "Schema";
        readonly eventbridge_schema_registry: "Schema Registry";
        readonly express_workflows: "AWS Express Workflows";
        readonly fargate: "AWS Fargate";
        readonly fault_injection_simulator: "AWS Fault Injection Simulator";
        readonly finspace: "Amazon FinSpace";
        readonly firewall_manager: "AWS Firewall Manager";
        readonly forecast: "Amazon Forecast";
        readonly fraud_detector: "Amazon Fraud Detector";
        readonly freertos: "FreeRTOS";
        readonly front_end_web_mobile: "Front End Web Mobile";
        readonly fsx: "Amazon FSx";
        readonly fsx_for_lustre: "Amazon FSx for Lustre";
        readonly fsx_for_netapp_ontap: "Amazon FSx for NetApp ONTAP";
        readonly fsx_for_openzfs: "Amazon FSx for OpenZFS";
        readonly fsx_for_wfs: "Amazon FSx for WFS";
        readonly game_tech: "Game Tech";
        readonly gamekit: "AWS GameKit";
        readonly gamelift: "Amazon GameLift";
        readonly gamesparks: "Amazon GameSparks";
        readonly genomics_cli: "Amazon Genomics CLI";
        readonly global_accelerator: "AWS Global Accelerator";
        readonly glue: "AWS Glue";
        readonly glue_crawler: "Crawler";
        readonly glue_data_catalog: "Data Catalog";
        readonly glue_databrew: "AWS Glue DataBrew";
        readonly glue_elastic_views: "AWS Glue Elastic Views";
        readonly ground_station: "AWS Ground Station";
        readonly guardduty: "Amazon GuardDuty";
        readonly healthlake: "Amazon HealthLake";
        readonly honeycode: "Amazon Honeycode";
        readonly iam: "AWS Identity and Access Management";
        readonly iam_add_on: "Add on";
        readonly iam_data_encryption_key: "Data Encryption Key";
        readonly iam_encrypted_data: "Encrypted Data";
        readonly iam_iam_access_analyzer: "IAM Access Analyzer";
        readonly iam_iam_roles_anywhere: "IAM Roles Anywhere";
        readonly iam_identity_center: "AWS IAM Identity Center";
        readonly iam_long_term_security_credential: "Long Term Security Credential";
        readonly iam_mfa_token: "MFA Token";
        readonly iam_permissions: "Permissions";
        readonly iam_role: "Role";
        readonly iam_sts: "AWS STS";
        readonly iam_sts_alternate: "AWS STS Alternate";
        readonly iam_temporary_security_credential: "Temporary Security Credential";
        readonly inspector: "Amazon Inspector";
        readonly inspector_agent: "Agent";
        readonly interactive_video_service: "Amazon Interactive Video Service";
        readonly internet_of_things: "Internet of Things";
        readonly iot_1_click: "AWS IoT 1-Click";
        readonly iot_analytics: "AWS IoT Analytics";
        readonly iot_analytics_channel: "Channel";
        readonly iot_analytics_data_store: "Data Store";
        readonly iot_analytics_dataset: "Dataset";
        readonly iot_analytics_notebook: "Notebook";
        readonly iot_analytics_pipeline: "Pipeline";
        readonly iot_button: "AWS IoT Button";
        readonly iot_core: "AWS IoT Core";
        readonly iot_core_action: "Action";
        readonly iot_core_actuator: "Actuator";
        readonly iot_core_certificate: "Certificate";
        readonly iot_core_desired_state: "Desired State";
        readonly iot_core_device_gateway: "Device Gateway";
        readonly iot_core_echo: "Echo";
        readonly iot_core_http2_protocol: "HTTP2 Protocol";
        readonly iot_core_lorawan_protocol: "LoRaWAN Protocol";
        readonly iot_core_over_air_update: "Over Air Update";
        readonly iot_core_policy: "Policy";
        readonly iot_core_reported_state: "Reported State";
        readonly iot_core_sailboat: "Sailboat";
        readonly iot_core_sensor: "Sensor";
        readonly iot_core_servo: "Servo";
        readonly iot_core_shadow: "Shadow";
        readonly iot_core_simulator: "Simulator";
        readonly iot_core_topic: "Topic";
        readonly iot_device_defender: "AWS IoT Device Defender";
        readonly iot_device_defender_iot_device_jobs: "IoT Device Jobs";
        readonly iot_device_management: "AWS IoT Device Management";
        readonly iot_device_management_fleet_hub: "Fleet Hub";
        readonly iot_edukit: "AWS IoT EduKit";
        readonly iot_events: "AWS IoT Events";
        readonly iot_expresslink: "AWS IoT ExpressLink";
        readonly iot_fleetwise: "AWS IoT FleetWise";
        readonly iot_greengrass: "AWS IoT Greengrass";
        readonly iot_greengrass_artifact: "Artifact";
        readonly iot_greengrass_component: "Component";
        readonly iot_greengrass_component_machine_learning: "Component Machine Learning";
        readonly iot_greengrass_component_nucleus: "Component Nucleus";
        readonly iot_greengrass_component_private: "Component Private";
        readonly iot_greengrass_component_public: "Component Public";
        readonly iot_greengrass_connector: "Connector";
        readonly iot_greengrass_interprocess_communication: "Interprocess Communication";
        readonly iot_greengrass_protocol: "Protocol";
        readonly iot_greengrass_recipe: "Recipe";
        readonly iot_greengrass_stream_manager: "Stream Manager";
        readonly iot_http_protocol: "Protocol";
        readonly iot_mqtt_protocol: "Protocol";
        readonly iot_roborunner: "AWS IoT RoboRunner";
        readonly iot_sitewise: "AWS IoT SiteWise";
        readonly iot_sitewise_asset: "Asset";
        readonly iot_sitewise_asset_hierarchy: "Asset Hierarchy";
        readonly iot_sitewise_asset_model: "Asset Model";
        readonly iot_sitewise_asset_properties: "Asset Properties";
        readonly iot_sitewise_data_streams: "Data Streams";
        readonly iot_things_graph: "AWS IoT Things Graph";
        readonly iot_twinmaker: "AWS IoT TwinMaker";
        readonly iq: "AWS IQ";
        readonly kendra: "Amazon Kendra";
        readonly key_management_service: "AWS Key Management Service";
        readonly keyspaces: "Amazon Keyspaces";
        readonly kinesis: "Amazon Kinesis";
        readonly kinesis_data_analytics: "Amazon Kinesis Data Analytics";
        readonly kinesis_data_streams: "Amazon Kinesis Data Streams";
        readonly kinesis_firehose: "Amazon Kinesis Firehose";
        readonly kinesis_video_streams: "Amazon Kinesis Video Streams";
        readonly lake_formation: "AWS Lake Formation";
        readonly lake_formation_data_lake: "Data Lake";
        readonly lambda: "AWS Lambda";
        readonly lambda_lambda_function: "Lambda Function";
        readonly launch_wizard: "AWS Launch Wizard";
        readonly lex: "Amazon Lex";
        readonly license_manager: "AWS License Manager";
        readonly license_manager_application_discovery: "Application Discovery";
        readonly license_manager_license_blending: "License Blending";
        readonly lightsail: "Amazon Lightsail";
        readonly local_zones: "AWS Local Zones";
        readonly location_service: "Amazon Location Service";
        readonly location_service_geofence: "Geofence";
        readonly location_service_map: "Map";
        readonly location_service_place: "Place";
        readonly location_service_routes: "Routes";
        readonly location_service_track: "Track";
        readonly lookout_for_equipment: "Amazon Lookout for Equipment";
        readonly lookout_for_metrics: "Amazon Lookout for Metrics";
        readonly lookout_for_vision: "Amazon Lookout for Vision";
        readonly lumberyard: "Amazon Lumberyard";
        readonly machine_learning: "Machine Learning";
        readonly macie: "Amazon Macie";
        readonly mainframe_modernization: "AWS Mainframe Modernization";
        readonly mainframe_modernization_analyzer: "Analyzer";
        readonly mainframe_modernization_compiler: "Compiler";
        readonly mainframe_modernization_converter: "Converter";
        readonly mainframe_modernization_developer: "Developer";
        readonly mainframe_modernization_runtime: "Runtime";
        readonly managed_blockchain: "Amazon Managed Blockchain";
        readonly managed_blockchain_blockchain: "Blockchain";
        readonly managed_grafana: "Amazon Managed Grafana";
        readonly managed_services: "AWS Managed Services";
        readonly management_console: "AWS Management Console";
        readonly management_governance: "Management Governance";
        readonly media_services: "Media Services";
        readonly memorydb_for_redis: "Amazon MemoryDB for Redis";
        readonly migration_evaluator: "AWS Migration Evaluator";
        readonly migration_hub: "AWS Migration Hub";
        readonly migration_hub_refactor_spaces_applications: "Refactor Spaces Applications";
        readonly migration_hub_refactor_spaces_environments: "Refactor Spaces Environments";
        readonly migration_hub_refactor_spaces_services: "Refactor Spaces Services";
        readonly migration_transfer: "Migration Transfer";
        readonly monitron: "Amazon Monitron";
        readonly mq: "Amazon MQ";
        readonly mq_broker: "Broker";
        readonly msk: "Amazon Managed Streaming for Apache Kafka";
        readonly msk_msk_connect: "Amazon MSK Connect";
        readonly mwaa: "Amazon Managed Workflows for Apache Airflow";
        readonly neptune: "Amazon Neptune";
        readonly network_firewall: "AWS Network Firewall";
        readonly network_firewall_endpoints: "Endpoints";
        readonly networking_content_delivery: "Networking Content Delivery";
        readonly neuron: "AWS Neuron";
        readonly nice_dcv: "NICE DCV";
        readonly nice_enginframe: "NICE EnginFrame";
        readonly nimble_studio: "Amazon Nimble Studio";
        readonly nitro_enclaves: "AWS Nitro Enclaves";
        readonly open_3d_engine: "Open 3D Engine";
        readonly opensearch: "Amazon OpenSearch Service";
        readonly opsworks: "AWS OpsWorks";
        readonly opsworks_apps: "Apps";
        readonly opsworks_deployments: "Deployments";
        readonly opsworks_instances: "Instances";
        readonly opsworks_layers: "Layers";
        readonly opsworks_monitoring: "Monitoring";
        readonly opsworks_permissions: "Permissions";
        readonly opsworks_resources: "Resources";
        readonly opsworks_stack2: "Stack2";
        readonly organizations: "AWS Organizations";
        readonly organizations_account: "Account";
        readonly organizations_management_account: "Management Account";
        readonly organizations_organizational_unit: "Organizational Unit";
        readonly outposts_family: "AWS Outposts family";
        readonly outposts_rack: "AWS Outposts rack";
        readonly outposts_servers: "AWS Outposts servers";
        readonly panorama: "AWS Panorama";
        readonly parallelcluster: "AWS ParallelCluster";
        readonly personal_health_dashboard: "AWS Personal Health Dashboard";
        readonly personalize: "Amazon Personalize";
        readonly pinpoint: "Amazon Pinpoint";
        readonly pinpoint_apis: "Amazon Pinpoint APIs";
        readonly pinpoint_journey: "Journey";
        readonly polly: "Amazon Polly";
        readonly private_5g: "AWS Private 5G";
        readonly privatelink: "AWS PrivateLink";
        readonly professional_services: "AWS Professional Services";
        readonly proton: "AWS Proton";
        readonly quantum_ledger_database: "Amazon Quantum Ledger Database";
        readonly quantum_technologies: "Quantum Technologies";
        readonly quicksight: "Amazon QuickSight";
        readonly rds: "Amazon RDS";
        readonly rds_instance: "RDS Instance";
        readonly rds_multi_az: "Multi AZ";
        readonly rds_multi_az_db_cluster: "Multi AZ DB Cluster";
        readonly rds_on_vmware: "Amazon RDS on VMware";
        readonly red_hat_openshift: "Red Hat OpenShift";
        readonly redshift: "Amazon Redshift";
        readonly redshift_dense_compute_node: "Dense Compute Node";
        readonly redshift_dense_storage_node: "Dense Storage Node";
        readonly redshift_ml: "ML";
        readonly redshift_ra3: "RA3";
        readonly rekognition: "Amazon Rekognition";
        readonly rekognition_image: "Image";
        readonly rekognition_video: "Video";
        readonly repost: "AWS rePost";
        readonly reserved_instance_reporting: "Reserved Instance Reporting";
        readonly resilience_hub: "AWS Resilience Hub";
        readonly resource_access_manager: "AWS Resource Access Manager";
        readonly robomaker: "AWS RoboMaker";
        readonly robomaker_cloud_extensions_ros: "Cloud Extensions ROS";
        readonly robomaker_development_environment: "Development Environment";
        readonly robomaker_fleet_management: "Fleet Management";
        readonly robomaker_simulation: "Simulation";
        readonly robotics: "Robotics";
        readonly route_53: "Amazon Route 53";
        readonly route_53_application_recovery_controller: "Application Recovery Controller";
        readonly route_53_hosted_zone: "Hosted Zone";
        readonly route_53_readiness_checks: "Readiness Checks";
        readonly route_53_resolver: "Resolver";
        readonly route_53_resolver_dns_firewall: "Resolver DNS Firewall";
        readonly route_53_resolver_query_logging: "Resolver Query Logging";
        readonly route_53_route_table: "Route Table";
        readonly route_53_routing_controls: "Routing Controls";
        readonly s3: "Amazon Simple Storage Service";
        readonly s3_bucket: "Bucket";
        readonly s3_bucket_with_objects: "Bucket With Objects";
        readonly s3_general_access_points: "General Access Points";
        readonly s3_glacier: "Amazon Simple Storage Service Glacier";
        readonly s3_glacier_archive: "Archive";
        readonly s3_glacier_deep_archive: "Deep Archive";
        readonly s3_glacier_flexible_retrieval: "Flexible Retrieval";
        readonly s3_glacier_instant_retrieval: "Instant Retrieval";
        readonly s3_glacier_vault: "Vault";
        readonly s3_object: "Object";
        readonly s3_on_outposts: "Amazon S3 on Outposts";
        readonly s3_s3_intelligent_tiering: "S3 Intelligent Tiering";
        readonly s3_s3_object_lambda: "S3 Object Lambda";
        readonly s3_s3_object_lambda_access_points: "S3 Object Lambda Access Points";
        readonly s3_s3_on_outposts: "S3 On Outposts";
        readonly s3_s3_one_zone_ia: "S3 One Zone IA";
        readonly s3_s3_replication: "S3 Replication";
        readonly s3_s3_replication_time_control: "S3 Replication Time Control";
        readonly s3_s3_standard: "S3 Standard";
        readonly s3_s3_standard_ia: "S3 Standard IA";
        readonly s3_s3_storage_lens: "S3 Storage Lens";
        readonly s3_vpc_access_points: "VPC Access Points";
        readonly sagemaker: "Amazon SageMaker";
        readonly sagemaker_canvas: "Canvas";
        readonly sagemaker_ground_truth: "Amazon SageMaker Ground Truth";
        readonly sagemaker_model: "Model";
        readonly sagemaker_notebook: "Notebook";
        readonly sagemaker_studio_lab: "Amazon SageMaker Studio Lab";
        readonly sagemaker_train: "Train";
        readonly satellite: "Satellite";
        readonly savings_plans: "Savings Plans";
        readonly secrets_manager: "AWS Secrets Manager";
        readonly security_hub: "AWS Security Hub";
        readonly security_hub_finding: "Finding";
        readonly security_identity_compliance: "Security Identity Compliance";
        readonly server_migration_service: "AWS Server Migration Service";
        readonly serverless: "Serverless";
        readonly serverless_application_repository: "AWS Serverless Application Repository";
        readonly service_catalog: "AWS Service Catalog";
        readonly ses: "Amazon Simple Email Service";
        readonly ses_email: "Email";
        readonly shield: "AWS Shield";
        readonly shield_shield_advanced: "AWS Shield Advanced";
        readonly signer: "AWS Signer";
        readonly site_to_site_vpn: "AWS Site to Site VPN";
        readonly snowball: "AWS Snowball";
        readonly snowball_edge: "AWS Snowball Edge";
        readonly snowball_snowball_import_export: "Snowball Import Export";
        readonly snowcone: "AWS Snowcone";
        readonly snowmobile: "AWS Snowmobile";
        readonly sns: "Amazon Simple Notification Service";
        readonly sns_email_notification: "Email Notification";
        readonly sns_http_notification: "HTTP Notification";
        readonly sns_topic: "Topic";
        readonly sqs: "Amazon Simple Queue Service";
        readonly sqs_message: "Message";
        readonly sqs_queue: "Queue";
        readonly ssm: "AWS Systems Manager";
        readonly ssm_automation: "Automation";
        readonly ssm_change_calendar: "Change Calendar";
        readonly ssm_change_manager: "Change Manager";
        readonly ssm_compliance: "Compliance";
        readonly ssm_documents: "Documents";
        readonly ssm_inventory: "Inventory";
        readonly ssm_maintenance_windows: "Maintenance Windows";
        readonly ssm_opscenter: "OpsCenter";
        readonly ssm_parameter_store: "Parameter Store";
        readonly ssm_patch_manager: "Patch Manager";
        readonly ssm_run_command: "Run Command";
        readonly ssm_session_manager: "Session Manager";
        readonly ssm_state_manager: "State Manager";
        readonly step_functions: "AWS Step Functions";
        readonly storage: "Storage";
        readonly storage_gateway: "AWS Storage Gateway";
        readonly storage_gateway_cached_volume: "Cached Volume";
        readonly storage_gateway_file_gateway: "File Gateway";
        readonly storage_gateway_fsx_file_gateway: "Amazon FSx File Gateway";
        readonly storage_gateway_noncached_volume: "Noncached Volume";
        readonly storage_gateway_s3_file_gateway: "Amazon S3 File Gateway";
        readonly storage_gateway_tape_gateway: "Tape Gateway";
        readonly storage_gateway_virtual_tape_library: "Virtual Tape Library";
        readonly storage_gateway_volume_gateway: "Volume Gateway";
        readonly sumerian: "Amazon Sumerian";
        readonly support: "AWS Support";
        readonly systems_manager_incident_manager: "AWS Systems Manager Incident Manager";
        readonly tensorflow_on_aws: "TensorFlow on AWS";
        readonly textract: "Amazon Textract";
        readonly thinkbox_deadline: "AWS Thinkbox Deadline";
        readonly thinkbox_frost: "AWS Thinkbox Frost";
        readonly thinkbox_krakatoa: "AWS Thinkbox Krakatoa";
        readonly thinkbox_sequoia: "AWS Thinkbox Sequoia";
        readonly thinkbox_stoke: "AWS Thinkbox Stoke";
        readonly thinkbox_xmesh: "AWS Thinkbox XMesh";
        readonly timestream: "Amazon Timestream";
        readonly tools_and_sdks: "AWS Tools and SDKs";
        readonly torchserve: "TorchServe";
        readonly training_certification: "AWS Training Certification";
        readonly transcribe: "Amazon Transcribe";
        readonly transfer_family: "AWS Transfer Family";
        readonly transfer_family_ftp: "AWS FTP";
        readonly transfer_family_ftps: "AWS FTPS";
        readonly transfer_family_sftp: "AWS SFTP";
        readonly transit_gateway: "AWS Transit Gateway";
        readonly transit_gateway_attachment: "Attachment";
        readonly translate: "Amazon Translate";
        readonly trusted_advisor: "AWS Trusted Advisor";
        readonly trusted_advisor_checklist: "Checklist";
        readonly trusted_advisor_checklist_cost: "Checklist Cost";
        readonly trusted_advisor_checklist_fault_tolerant: "Checklist Fault Tolerant";
        readonly trusted_advisor_checklist_performance: "Checklist Performance";
        readonly trusted_advisor_checklist_security: "Checklist Security";
        readonly vmware_cloud_on_aws: "VMware Cloud on AWS";
        readonly vpc: "Amazon Virtual Private Cloud";
        readonly vpc_carrier_gateway: "Carrier Gateway";
        readonly vpc_customer_gateway: "Customer Gateway";
        readonly vpc_elastic_network_adapter: "Elastic Network Adapter";
        readonly vpc_elastic_network_interface: "Elastic Network Interface";
        readonly vpc_endpoints: "Endpoints";
        readonly vpc_flow_logs: "Flow Logs";
        readonly vpc_internet_gateway: "Internet Gateway";
        readonly vpc_nat_gateway: "NAT Gateway";
        readonly vpc_network_access_analyzer: "Network Access Analyzer";
        readonly vpc_network_access_control_list: "Network Access Control List";
        readonly vpc_peering_connection: "Peering Connection";
        readonly vpc_reachability_analyzer: "Reachability Analyzer";
        readonly vpc_router: "Router";
        readonly vpc_traffic_mirroring: "Traffic Mirroring";
        readonly vpc_vpn_connection: "VPN Connection";
        readonly vpc_vpn_gateway: "VPN Gateway";
        readonly vr_ar: "VR AR";
        readonly waf: "AWS WAF";
        readonly waf_bad_bot: "Bad Bot";
        readonly waf_bot: "Bot";
        readonly waf_bot_control: "Bot Control";
        readonly waf_filtering_rule: "Filtering Rule";
        readonly waf_labels: "Labels";
        readonly waf_managed_rule: "Managed Rule";
        readonly waf_rule: "Rule";
        readonly wavelength: "AWS Wavelength";
        readonly well_architected_tool: "AWS Well Architected Tool";
        readonly workdocs: "Amazon WorkDocs";
        readonly workdocs_sdk: "Amazon WorkDocs SDK";
        readonly worklink: "Amazon WorkLink";
        readonly workmail: "Amazon WorkMail";
        readonly workspaces: "Amazon WorkSpaces";
        readonly workspaces_web: "Amazon WorkSpaces Web";
        readonly x_ray: "AWS X-Ray";
    };
    /**
     * Static list of all avaliable asset files - stored as const to prevent async io at runtime
     * @internal
     **/
    const AssetFiles: Set<string>;
}
