"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DRAWIO_EXPLICIT_MAPPING = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const assets_1 = require("../../generated/assets");
/** Explicit mapping of drawio shapes to asset keys */
exports.DRAWIO_EXPLICIT_MAPPING = {
    access_analyzer: assets_1.AwsAsset.Resources.iam_iam_access_analyzer,
    agent: assets_1.AwsAsset.Resources.inspector_agent,
    agent2: assets_1.AwsAsset.Resources.datasync_agent,
    cluster: assets_1.AwsAsset.Resources.emr_cluster,
    connect: assets_1.AwsAsset.Resources.iot_greengrass_connector,
    archive: assets_1.AwsAsset.Resources.s3_glacier_archive,
    endpoints: assets_1.AwsAsset.Resources.vpc_endpoints,
    endpoint: assets_1.AwsAsset.Resources.network_firewall_endpoints,
    gateway: assets_1.AwsAsset.Resources.direct_connect_gateway,
    instance: assets_1.AwsAsset.Resources.ec2_instance,
    instances: assets_1.AwsAsset.Resources.ec2_instances,
    intelligent_tiering: assets_1.AwsAsset.Resources.s3_s3_intelligent_tiering,
    // iot_over_the_air_update: AwsAsset.Resources['iot_core_over_air_update'],
    registry: assets_1.AwsAsset.Resources.ecr_registry,
    router: assets_1.AwsAsset.Resources.vpc_router,
    simulator: assets_1.AwsAsset.Resources.iot_core_simulator,
    table: assets_1.AwsAsset.Resources.dynamodb_table,
    topic_2: assets_1.AwsAsset.Resources.iot_core_topic,
    topic: assets_1.AwsAsset.Resources.sns_topic,
    vault: assets_1.AwsAsset.Resources.s3_glacier_vault,
    volume: assets_1.AwsAsset.Resources.ebs_volume,
    peering: assets_1.AwsAsset.Resources.vpc_peering_connection,
    service: assets_1.AwsAsset.Services.ec2,
};
//# sourceMappingURL=data:application/json;base64,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