import { AwsAsset } from "../../generated/assets";
/** @internal */
export declare function resolveServiceName(value: string): AwsAsset.Service;
/**
 * Extracted service name definition
 * @internal
 */
export interface ExtractedServiceName {
    readonly serviceName: AwsAsset.Service;
    readonly match: string;
    readonly rest?: string;
    readonly resolvedValue: string;
}
/**
 * Extract service name parts from value that is or contains a service name or variant of service name.
 * @internal
 */
export declare function extractResolvedServiceName(value: string): ExtractedServiceName | undefined;
