/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { ExtendedNagResult } from "../../pdk-nag";
import * as BASE_THREAT_MODEL from "./base-model/threat-composer-base-model.tc.json";
import { ThreatComposerApplicationDetails } from "./types";
type ThreatComposerModel = typeof BASE_THREAT_MODEL;
/**
 * Options for generating a Threat Composer threat model
 */
export interface ThreatModelGeneratorOptions {
    /**
     * Details about the application to include in the threat model
     */
    readonly applicationDetails?: ThreatComposerApplicationDetails;
    /**
     * A data uri for an architecture diagram image
     */
    readonly architectureImageDataUri?: string;
}
/**
 * Generates Threat Composer threat models based on CDK Nag results
 */
export declare class ThreatModelGenerator {
    /**
     * Given a Threat Composer mitigation, return the CDK Nag rule associated (if any)
     */
    private getRuleFromMitigation;
    /**
     * Deduplicate suppression reasons, removing resource details if present
     */
    private prettySuppressions;
    /**
     * Generate a threat model from a set of cdk nag results
     */
    generate(results: ExtendedNagResult[], options?: ThreatModelGeneratorOptions): ThreatComposerModel;
}
export {};
