"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCustomSynthesis = addCustomSynthesis;
exports.constructInfoFromConstruct = constructInfoFromConstruct;
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 *
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L17
 *
 * @internal
 */
const JSII_RUNTIME_SYMBOL = Symbol.for("jsii.rtti");
/**
 * Symbol to identify custom cdk synthesis method.
 *
 * @internal
 */
const CUSTOM_SYNTHESIS_SYM = Symbol.for("@aws-cdk/core:customSynthesis");
/**
 * Cdk internal function for mapping construct synthesis property
 * for custom synthesis handling.
 *
 * @internal
 */
function addCustomSynthesis(construct, synthesis) {
    Object.defineProperty(construct, CUSTOM_SYNTHESIS_SYM, {
        value: synthesis,
        enumerable: false,
    });
}
/**
 * Retrieve {@link ConstructInfo} for a {@link IConstruct}
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L46
 */
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === "object" &&
        jsiiRuntimeInfo !== null &&
        typeof jsiiRuntimeInfo.fqn === "string" &&
        typeof jsiiRuntimeInfo.version === "string") {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
//# sourceMappingURL=data:application/json;base64,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