"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_OUTDIR = exports.CDK_OUTDIR_VAR = exports.CDK_GRAPH_RC = void 0;
exports.resolveConfig = resolveConfig;
exports.resolveOutdir = resolveOutdir;
const findUp = require("find-up"); // eslint-disable-line @typescript-eslint/no-require-imports
/** CdkGraph config file name */
exports.CDK_GRAPH_RC = ".cdkgraphrc.js";
/** Variable replacement token for cdk.out directory */
exports.CDK_OUTDIR_VAR = "<cdk.out>";
/** Default graph artifact output directory */
exports.DEFAULT_OUTDIR = `${exports.CDK_OUTDIR_VAR}/cdkgraph`;
/** Default CdkGraph configuration */
const DEFAULT_CONFIG = {
    outdir: exports.DEFAULT_OUTDIR,
};
/**
 * Resolve CdkGraph runtime configuration. Will detect local file system config if available and
 * merge with default configuration.
 * @internal
 */
function resolveConfig(cwd) {
    const config = findUp.sync(exports.CDK_GRAPH_RC, { cwd });
    if (config) {
        return {
            ...DEFAULT_CONFIG,
            ...require(config), // eslint-disable-line @typescript-eslint/no-require-imports
        };
    }
    return { ...DEFAULT_CONFIG };
}
/**
 * Resolve CdkGraph output directory. Performs replacement of tokens in config path.
 * @internal
 */
function resolveOutdir(cdkOutdir, outdir = exports.DEFAULT_OUTDIR) {
    return outdir.replace(exports.CDK_OUTDIR_VAR, cdkOutdir);
}
//# sourceMappingURL=data:application/json;base64,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