"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findReferencesOfSubGraph = findReferencesOfSubGraph;
/** @internal */
function findReferencesOfSubGraph(subgraph, depth, predicate, strict = true) {
    const chain = new Set();
    if (depth == null) {
        depth = Number.MAX_SAFE_INTEGER;
    }
    function follow(_node, _depth) {
        if (_depth >= depth)
            return;
        for (const _ref of _node.references) {
            if (predicate && !predicate.filter(_ref))
                continue;
            if (_ref === subgraph || chain.has(_ref))
                continue;
            chain.add(_ref);
            follow(_ref, _depth + 1);
        }
        for (const child of _node.children) {
            if (predicate && !predicate.filter(child))
                continue;
            follow(child, _depth + 1);
        }
    }
    follow(subgraph, 0);
    if (strict) {
        for (const ref of chain) {
            if (ref.referencedBy.filter((_by) => !(_by === subgraph || _by.isAncestor(subgraph)) && !chain.has(_by)).length) {
                chain.delete(ref);
            }
        }
    }
    return Array.from(chain);
}
//# sourceMappingURL=data:application/json;base64,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