"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
const userpool_with_mfa_1 = require("./userpool-with-mfa");
const WEB_CLIENT_ID = "WebClient";
/**
 * Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        this.userPool = !props?.userPool
            ? new userpool_with_mfa_1.UserPoolWithMfa(this, "UserPool", props?.allowSignup ? { selfSignUpEnabled: true } : undefined)
            : props.userPool;
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", props?.identityPoolOptions);
        const existingClient = this.userPool.node.children.find((e) => e.node.id === WEB_CLIENT_ID && e instanceof aws_cognito_1.UserPoolClient);
        this.userPoolClient =
            existingClient ??
                this.userPool.addClient(WEB_CLIENT_ID, {
                    authFlows: {
                        userPassword: true,
                        userSrp: true,
                    },
                });
        this.identityPool.addUserPoolAuthentication(new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        }));
        new aws_cdk_lib_1.CfnOutput(this, `${id}-UserPoolId`, {
            value: this.userPool.userPoolId,
        });
        new aws_cdk_lib_1.CfnOutput(this, `${id}-IdentityPoolId`, {
            value: this.identityPool.identityPoolId,
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws/pdk.identity.UserIdentity", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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