"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Syncpack = void 0;
// JSII compatible fork of types from https://github.com/JamieMason/syncpack/blob/main/src/config/types.ts (v12.3.0)
/**
 * Types and constants for Syncpack usage in the monorepo
 * @see https://jamiemason.github.io/syncpack
 */
var Syncpack;
(function (Syncpack) {
    Syncpack.CUSTOM_TYPES = {
        dev: {
            strategy: "versionsByName",
            path: "devDependencies",
        },
        local: {
            strategy: "name~version",
            namePath: "name",
            path: "version",
        },
        overrides: {
            strategy: "versionsByName",
            path: "overrides",
        },
        peer: {
            strategy: "versionsByName",
            path: "peerDependencies",
        },
        pnpmOverrides: {
            strategy: "versionsByName",
            path: "pnpm.overrides",
        },
        prod: {
            strategy: "versionsByName",
            path: "dependencies",
        },
        resolutions: {
            strategy: "versionsByName",
            path: "resolutions",
        },
    };
    /**
     * Default monorepo configuration for Syncpack
     * @see https://jamiemason.github.io/syncpack/
     */
    Syncpack.DEFAULT_CONFIG = {
        filter: ".",
        indent: "  ",
        semverGroups: [
            {
                dependencies: ["**"],
                dependencyTypes: ["**"],
                packages: ["**"],
                range: "",
            },
        ],
        sortAz: [
            "contributors",
            "dependencies",
            "devDependencies",
            "keywords",
            "peerDependencies",
            "resolutions",
            "scripts",
        ],
        sortFirst: ["name", "description", "version", "author"],
        source: [],
        versionGroups: [],
    };
})(Syncpack || (exports.Syncpack = Syncpack = {}));
//# sourceMappingURL=data:application/json;base64,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