"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDiff = exports.autofixMergeConflicts = void 0;
const merge_lockfile_changes_1 = require("@pnpm/merge-lockfile-changes");
const js_yaml_1 = __importDefault(require("js-yaml"));
const inlineSpecifiersLockfileConverters_1 = require("./experiments/inlineSpecifiersLockfileConverters");
const MERGE_CONFLICT_PARENT = '|||||||';
const MERGE_CONFLICT_END = '>>>>>>>';
const MERGE_CONFLICT_THEIRS = '=======';
const MERGE_CONFLICT_OURS = '<<<<<<<';
function autofixMergeConflicts(fileContent) {
    const { ours, theirs } = parseMergeFile(fileContent);
    return (0, merge_lockfile_changes_1.mergeLockfileChanges)((0, inlineSpecifiersLockfileConverters_1.revertFromInlineSpecifiersFormatIfNecessary)(js_yaml_1.default.load(ours)), (0, inlineSpecifiersLockfileConverters_1.revertFromInlineSpecifiersFormatIfNecessary)(js_yaml_1.default.load(theirs)));
}
exports.autofixMergeConflicts = autofixMergeConflicts;
function parseMergeFile(fileContent) {
    const lines = fileContent.split(/[\n\r]+/g);
    let state = 'top';
    const ours = [];
    const theirs = [];
    while (lines.length > 0) {
        const line = lines.shift();
        if (line.startsWith(MERGE_CONFLICT_PARENT)) {
            state = 'parent';
            continue;
        }
        if (line.startsWith(MERGE_CONFLICT_OURS)) {
            state = 'ours';
            continue;
        }
        if (line === MERGE_CONFLICT_THEIRS) {
            state = 'theirs';
            continue;
        }
        if (line.startsWith(MERGE_CONFLICT_END)) {
            state = 'top';
            continue;
        }
        if (state === 'top' || state === 'ours')
            ours.push(line);
        if (state === 'top' || state === 'theirs')
            theirs.push(line);
    }
    return { ours: ours.join('\n'), theirs: theirs.join('\n') };
}
function isDiff(fileContent) {
    return fileContent.includes(MERGE_CONFLICT_OURS) &&
        fileContent.includes(MERGE_CONFLICT_THEIRS) &&
        fileContent.includes(MERGE_CONFLICT_END);
}
exports.isDiff = isDiff;
//# sourceMappingURL=gitMergeFile.js.map