"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeLockfiles = exports.normalizeLockfile = exports.isEmptyLockfile = exports.writeCurrentLockfile = exports.writeWantedLockfile = void 0;
const fs_1 = require("fs");
const path_1 = __importDefault(require("path"));
const types_1 = require("@pnpm/types");
const constants_1 = require("@pnpm/constants");
const rimraf_1 = __importDefault(require("@zkochan/rimraf"));
const dp = __importStar(require("@pnpm/dependency-path"));
const js_yaml_1 = __importDefault(require("js-yaml"));
const equals_1 = __importDefault(require("ramda/src/equals"));
const pickBy_1 = __importDefault(require("ramda/src/pickBy"));
const isEmpty_1 = __importDefault(require("ramda/src/isEmpty"));
const map_1 = __importDefault(require("ramda/src/map"));
const write_file_atomic_1 = __importDefault(require("write-file-atomic"));
const logger_1 = require("./logger");
const sortLockfileKeys_1 = require("./sortLockfileKeys");
const lockfileName_1 = require("./lockfileName");
const inlineSpecifiersLockfileConverters_1 = require("./experiments/inlineSpecifiersLockfileConverters");
async function writeFileAtomic(filename, data) {
    return new Promise((resolve, reject) => {
        (0, write_file_atomic_1.default)(filename, data, {}, (err) => {
            (err != null) ? reject(err) : resolve();
        });
    });
}
const LOCKFILE_YAML_FORMAT = {
    blankLines: true,
    lineWidth: -1, // This is setting line width to never wrap
    noCompatMode: true,
    noRefs: true,
    sortKeys: false,
};
async function writeWantedLockfile(pkgPath, wantedLockfile, opts) {
    const wantedLockfileName = await (0, lockfileName_1.getWantedLockfileName)(opts);
    return writeLockfile(wantedLockfileName, pkgPath, wantedLockfile, opts);
}
exports.writeWantedLockfile = writeWantedLockfile;
async function writeCurrentLockfile(virtualStoreDir, currentLockfile, opts) {
    // empty lockfile is not saved
    if (isEmptyLockfile(currentLockfile)) {
        await (0, rimraf_1.default)(path_1.default.join(virtualStoreDir, 'lock.yaml'));
        return;
    }
    await fs_1.promises.mkdir(virtualStoreDir, { recursive: true });
    return writeLockfile('lock.yaml', virtualStoreDir, currentLockfile, opts);
}
exports.writeCurrentLockfile = writeCurrentLockfile;
async function writeLockfile(lockfileFilename, pkgPath, wantedLockfile, opts) {
    const lockfilePath = path_1.default.join(pkgPath, lockfileFilename);
    const isLockfileV6 = wantedLockfile['lockfileVersion'].toString().startsWith('6.');
    const lockfileToStringify = isLockfileV6
        ? (0, inlineSpecifiersLockfileConverters_1.convertToInlineSpecifiersFormat)(wantedLockfile)
        : wantedLockfile;
    const yamlDoc = yamlStringify(lockfileToStringify, {
        forceSharedFormat: opts?.forceSharedFormat === true,
        includeEmptySpecifiersField: !isLockfileV6,
    });
    return writeFileAtomic(lockfilePath, yamlDoc);
}
function yamlStringify(lockfile, opts) {
    let normalizedLockfile = normalizeLockfile(lockfile, opts);
    normalizedLockfile = (0, sortLockfileKeys_1.sortLockfileKeys)(normalizedLockfile);
    return js_yaml_1.default.dump(normalizedLockfile, LOCKFILE_YAML_FORMAT);
}
function isEmptyLockfile(lockfile) {
    return Object.values(lockfile.importers).every((importer) => (0, isEmpty_1.default)(importer.specifiers ?? {}) && (0, isEmpty_1.default)(importer.dependencies ?? {}));
}
exports.isEmptyLockfile = isEmptyLockfile;
function normalizeLockfile(lockfile, opts) {
    let lockfileToSave;
    if (!opts.forceSharedFormat && (0, equals_1.default)(Object.keys(lockfile.importers), ['.'])) {
        lockfileToSave = {
            ...lockfile,
            ...lockfile.importers['.'],
        };
        delete lockfileToSave.importers;
        for (const depType of types_1.DEPENDENCIES_FIELDS) {
            if ((0, isEmpty_1.default)(lockfileToSave[depType])) {
                delete lockfileToSave[depType];
            }
        }
        if ((0, isEmpty_1.default)(lockfileToSave.packages) || (lockfileToSave.packages == null)) {
            delete lockfileToSave.packages;
        }
    }
    else {
        lockfileToSave = {
            ...lockfile,
            importers: (0, map_1.default)((importer) => {
                const normalizedImporter = {};
                if (!(0, isEmpty_1.default)(importer.specifiers ?? {}) || opts.includeEmptySpecifiersField) {
                    normalizedImporter['specifiers'] = importer.specifiers ?? {};
                }
                if (importer.dependenciesMeta != null && !(0, isEmpty_1.default)(importer.dependenciesMeta)) {
                    normalizedImporter['dependenciesMeta'] = importer.dependenciesMeta;
                }
                for (const depType of types_1.DEPENDENCIES_FIELDS) {
                    if (!(0, isEmpty_1.default)(importer[depType] ?? {})) {
                        normalizedImporter[depType] = importer[depType];
                    }
                }
                if (importer.publishDirectory) {
                    normalizedImporter.publishDirectory = importer.publishDirectory;
                }
                return normalizedImporter;
            }, lockfile.importers),
        };
        if ((0, isEmpty_1.default)(lockfileToSave.packages) || (lockfileToSave.packages == null)) {
            delete lockfileToSave.packages;
        }
    }
    if (lockfileToSave.time) {
        lockfileToSave.time = (lockfileToSave.lockfileVersion.toString().startsWith('6.') ? pruneTimeInLockfileV6 : pruneTime)(lockfileToSave.time, lockfile.importers);
    }
    if ((lockfileToSave.overrides != null) && (0, isEmpty_1.default)(lockfileToSave.overrides)) {
        delete lockfileToSave.overrides;
    }
    if ((lockfileToSave.patchedDependencies != null) && (0, isEmpty_1.default)(lockfileToSave.patchedDependencies)) {
        delete lockfileToSave.patchedDependencies;
    }
    if (lockfileToSave.neverBuiltDependencies != null) {
        if ((0, isEmpty_1.default)(lockfileToSave.neverBuiltDependencies)) {
            delete lockfileToSave.neverBuiltDependencies;
        }
        else {
            lockfileToSave.neverBuiltDependencies = lockfileToSave.neverBuiltDependencies.sort();
        }
    }
    if (lockfileToSave.onlyBuiltDependencies != null) {
        lockfileToSave.onlyBuiltDependencies = lockfileToSave.onlyBuiltDependencies.sort();
    }
    if (!lockfileToSave.packageExtensionsChecksum) {
        delete lockfileToSave.packageExtensionsChecksum;
    }
    return lockfileToSave;
}
exports.normalizeLockfile = normalizeLockfile;
function pruneTimeInLockfileV6(time, importers) {
    const rootDepPaths = new Set();
    for (const importer of Object.values(importers)) {
        for (const depType of types_1.DEPENDENCIES_FIELDS) {
            for (let [depName, ref] of Object.entries(importer[depType] ?? {})) {
                // @ts-expect-error
                if (ref['version'])
                    ref = ref['version'];
                const suffixStart = ref.indexOf('(');
                const refWithoutPeerSuffix = suffixStart === -1 ? ref : ref.slice(0, suffixStart);
                const depPath = refToRelative(refWithoutPeerSuffix, depName);
                if (!depPath)
                    continue;
                rootDepPaths.add(depPath);
            }
        }
    }
    return (0, pickBy_1.default)((_, depPath) => rootDepPaths.has(depPath), time);
}
function refToRelative(reference, pkgName) {
    if (reference.startsWith('link:')) {
        return null;
    }
    if (reference.startsWith('file:')) {
        return reference;
    }
    if (!reference.includes('/') || !reference.replace(/(\([^)]+\))+$/, '').includes('/')) {
        return `/${pkgName}@${reference}`;
    }
    return reference;
}
function pruneTime(time, importers) {
    const rootDepPaths = new Set();
    for (const importer of Object.values(importers)) {
        for (const depType of types_1.DEPENDENCIES_FIELDS) {
            for (let [depName, ref] of Object.entries(importer[depType] ?? {})) {
                // @ts-expect-error
                if (ref['version'])
                    ref = ref['version'];
                const suffixStart = ref.indexOf('_');
                const refWithoutPeerSuffix = suffixStart === -1 ? ref : ref.slice(0, suffixStart);
                const depPath = dp.refToRelative(refWithoutPeerSuffix, depName);
                if (!depPath)
                    continue;
                rootDepPaths.add(depPath);
            }
        }
    }
    return (0, pickBy_1.default)((t, depPath) => rootDepPaths.has(depPath), time);
}
async function writeLockfiles(opts) {
    const wantedLockfileName = await (0, lockfileName_1.getWantedLockfileName)(opts);
    const wantedLockfilePath = path_1.default.join(opts.wantedLockfileDir, wantedLockfileName);
    const currentLockfilePath = path_1.default.join(opts.currentLockfileDir, 'lock.yaml');
    const forceSharedFormat = opts?.forceSharedFormat === true;
    const isLockfileV6 = opts.wantedLockfile.lockfileVersion.toString().startsWith('6.');
    const wantedLockfileToStringify = isLockfileV6
        ? (0, inlineSpecifiersLockfileConverters_1.convertToInlineSpecifiersFormat)(opts.wantedLockfile)
        : opts.wantedLockfile;
    const normalizeOpts = {
        forceSharedFormat,
        includeEmptySpecifiersField: !isLockfileV6,
    };
    const yamlDoc = yamlStringify(wantedLockfileToStringify, normalizeOpts);
    // in most cases the `pnpm-lock.yaml` and `node_modules/.pnpm-lock.yaml` are equal
    // in those cases the YAML document can be stringified only once for both files
    // which is more efficient
    if (opts.wantedLockfile === opts.currentLockfile) {
        await Promise.all([
            writeFileAtomic(wantedLockfilePath, yamlDoc),
            (async () => {
                if (isEmptyLockfile(opts.wantedLockfile)) {
                    await (0, rimraf_1.default)(currentLockfilePath);
                }
                else {
                    await fs_1.promises.mkdir(path_1.default.dirname(currentLockfilePath), { recursive: true });
                    await writeFileAtomic(currentLockfilePath, yamlDoc);
                }
            })(),
        ]);
        return;
    }
    logger_1.lockfileLogger.debug({
        message: `\`${constants_1.WANTED_LOCKFILE}\` differs from \`${path_1.default.relative(opts.wantedLockfileDir, currentLockfilePath)}\``,
        prefix: opts.wantedLockfileDir,
    });
    const currentLockfileToStringify = opts.wantedLockfile.lockfileVersion.toString().startsWith('6.')
        ? (0, inlineSpecifiersLockfileConverters_1.convertToInlineSpecifiersFormat)(opts.currentLockfile)
        : opts.currentLockfile;
    const currentYamlDoc = yamlStringify(currentLockfileToStringify, normalizeOpts);
    await Promise.all([
        writeFileAtomic(wantedLockfilePath, yamlDoc),
        (async () => {
            if (isEmptyLockfile(opts.wantedLockfile)) {
                await (0, rimraf_1.default)(currentLockfilePath);
            }
            else {
                await fs_1.promises.mkdir(path_1.default.dirname(currentLockfilePath), { recursive: true });
                await writeFileAtomic(currentLockfilePath, currentYamlDoc);
            }
        })(),
    ]);
}
exports.writeLockfiles = writeLockfiles;
//# sourceMappingURL=write.js.map