"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeLockfileChanges = void 0;
const comver_to_semver_1 = __importDefault(require("comver-to-semver"));
const semver_1 = __importDefault(require("semver"));
function mergeLockfileChanges(ours, theirs) {
    const newLockfile = {
        importers: {},
        lockfileVersion: semver_1.default.gt((0, comver_to_semver_1.default)(theirs.lockfileVersion.toString()), (0, comver_to_semver_1.default)(ours.lockfileVersion.toString()))
            ? theirs.lockfileVersion
            : ours.lockfileVersion,
    };
    for (const importerId of Array.from(new Set([...Object.keys(ours.importers), ...Object.keys(theirs.importers)]))) {
        newLockfile.importers[importerId] = {
            specifiers: {},
        };
        for (const key of ['dependencies', 'devDependencies', 'optionalDependencies']) {
            newLockfile.importers[importerId][key] = mergeDict(ours.importers[importerId]?.[key] ?? {}, theirs.importers[importerId]?.[key] ?? {}, mergeVersions);
            if (Object.keys(newLockfile.importers[importerId][key] ?? {}).length === 0) {
                delete newLockfile.importers[importerId][key];
            }
        }
        newLockfile.importers[importerId].specifiers = mergeDict(ours.importers[importerId]?.specifiers ?? {}, theirs.importers[importerId]?.specifiers ?? {}, takeChangedValue);
    }
    const packages = {};
    for (const depPath of Array.from(new Set([...Object.keys(ours.packages ?? {}), ...Object.keys(theirs.packages ?? {})]))) {
        const ourPkg = ours.packages?.[depPath];
        const theirPkg = theirs.packages?.[depPath];
        const pkg = {
            ...ourPkg,
            ...theirPkg,
        };
        for (const key of ['dependencies', 'optionalDependencies']) {
            pkg[key] = mergeDict(ourPkg?.[key] ?? {}, theirPkg?.[key] ?? {}, mergeVersions);
            if (Object.keys(pkg[key] ?? {}).length === 0) {
                delete pkg[key];
            }
        }
        packages[depPath] = pkg;
    }
    newLockfile.packages = packages;
    return newLockfile;
}
exports.mergeLockfileChanges = mergeLockfileChanges;
function mergeDict(ourDict, theirDict, valueMerger) {
    const newDict = {};
    for (const key of Object.keys(ourDict).concat(Object.keys(theirDict))) {
        const changedValue = valueMerger(ourDict[key], theirDict[key]);
        if (changedValue) {
            newDict[key] = changedValue;
        }
    }
    return newDict;
}
function takeChangedValue(ourValue, theirValue) {
    if (ourValue === theirValue || theirValue == null)
        return ourValue;
    return theirValue;
}
function mergeVersions(ourValue, theirValue) {
    if (ourValue === theirValue || !theirValue)
        return ourValue;
    if (!ourValue)
        return theirValue;
    const [ourVersion] = ourValue.split('_');
    const [theirVersion] = theirValue.split('_');
    if (semver_1.default.gt(ourVersion, theirVersion)) {
        return ourValue;
    }
    return theirValue;
}
//# sourceMappingURL=index.js.map