"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPackagesSearcher = void 0;
const matcher_1 = require("@pnpm/matcher");
const npm_package_arg_1 = __importDefault(require("@pnpm/npm-package-arg"));
const semver_1 = __importDefault(require("semver"));
function createPackagesSearcher(queries) {
    const searchers = queries
        .map(parseSearchQuery)
        .map((packageSelector) => search.bind(null, packageSelector));
    return (pkg) => searchers.some((search) => search(pkg));
}
exports.createPackagesSearcher = createPackagesSearcher;
function search(packageSelector, pkg) {
    if (!packageSelector.matchName(pkg.name)) {
        return false;
    }
    if (packageSelector.matchVersion == null) {
        return true;
    }
    return !pkg.version.startsWith('link:') && packageSelector.matchVersion(pkg.version);
}
function parseSearchQuery(query) {
    const parsed = (0, npm_package_arg_1.default)(query);
    if (parsed.raw === parsed.name) {
        return { matchName: (0, matcher_1.createMatcher)(parsed.name) };
    }
    if (parsed.type !== 'version' && parsed.type !== 'range') {
        throw new Error(`Invalid query - ${query}. List can search only by version or range`);
    }
    return {
        matchName: (0, matcher_1.createMatcher)(parsed.name),
        matchVersion: (version) => semver_1.default.satisfies(version, parsed.fetchSpec),
    };
}
//# sourceMappingURL=createPackagesSearcher.js.map