/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { INagLogger, NagLoggerComplianceData, NagLoggerErrorData, NagLoggerNonComplianceData, NagLoggerNotApplicableData, NagLoggerSuppressedData, NagLoggerSuppressedErrorData } from "cdk-nag";
import { ExtendedNagResult } from "./types";
/**
 * Records nag results in memory
 */
export declare class MemoryLogger implements INagLogger {
    readonly results: ExtendedNagResult[];
    onCompliance(data: NagLoggerComplianceData): void;
    onNonCompliance(data: NagLoggerNonComplianceData): void;
    onSuppressed(data: NagLoggerSuppressedData): void;
    onError(data: NagLoggerErrorData): void;
    onSuppressedError(data: NagLoggerSuppressedErrorData): void;
    onNotApplicable(data: NagLoggerNotApplicableData): void;
}
