"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagResultCompliance = void 0;
/**
 * Possible statuses for nag rules
 */
var NagResultCompliance;
(function (NagResultCompliance) {
    /**
     * Resource complies with the rule
     */
    NagResultCompliance["COMPLIANT"] = "COMPLIANT";
    /**
     * Resource does not comply with the rule
     */
    NagResultCompliance["NON_COMPLIANT"] = "NON_COMPLIANT";
    /**
     * Resource does not comply with the rule, but the rule was suppressed
     */
    NagResultCompliance["NON_COMPLIANT_SUPPRESSED"] = "NON_COMPLIANT_SUPPRESSED";
    /**
     * An error occurred applying the rule
     */
    NagResultCompliance["ERROR"] = "ERROR";
    /**
     * An error occurred applying the rule, but the rule was suppressed
     */
    NagResultCompliance["ERROR_SUPPRESSED"] = "ERROR_SUPPRESSED";
    /**
     * The rule is not applicable to the resource
     */
    NagResultCompliance["NOT_APPLICABLE"] = "NOT_APPLICABLE";
})(NagResultCompliance || (exports.NagResultCompliance = NagResultCompliance = {}));
//# sourceMappingURL=data:application/json;base64,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