"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositeIntegrationResponseSet = exports.CustomIntegrationResponseSet = exports.S3JsonErrorMessageIntegrationResponseSet = exports.DefaultPassthroughIntegrationResponseSet = exports.CatchAllErrorIntegrationResponseSet = exports.IntegrationResponseSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const prepare_spec_1 = require("../prepare-spec-event-handler/prepare-spec");
/**
 * A set of integration responses. You can extend this to implement your own integration response set
 */
class IntegrationResponseSet {
}
exports.IntegrationResponseSet = IntegrationResponseSet;
_a = JSII_RTTI_SYMBOL_1;
IntegrationResponseSet[_a] = { fqn: "@aws/pdk.type_safe_api.IntegrationResponseSet", version: "0.25.8" };
/**
 * An integration response set that catches all errors and returns a 500
 */
class CatchAllErrorIntegrationResponseSet extends IntegrationResponseSet {
    render(props) {
        return {
            "(4|5)\\d{2}": {
                statusCode: "500",
                responseParameters: props.corsOptions
                    ? (0, prepare_spec_1.generateCorsResponseParameters)(props.corsOptions)
                    : {},
                responseTemplates: {},
            },
        };
    }
}
exports.CatchAllErrorIntegrationResponseSet = CatchAllErrorIntegrationResponseSet;
_b = JSII_RTTI_SYMBOL_1;
CatchAllErrorIntegrationResponseSet[_b] = { fqn: "@aws/pdk.type_safe_api.CatchAllErrorIntegrationResponseSet", version: "0.25.8" };
/**
 * An integration response set which adds a passthrough for the default response
 */
class DefaultPassthroughIntegrationResponseSet extends IntegrationResponseSet {
    constructor(props) {
        super();
        this.statusCode = props?.statusCode ?? 200;
    }
    render(props) {
        return {
            default: {
                statusCode: `${this.statusCode}`,
                responseParameters: props.corsOptions
                    ? (0, prepare_spec_1.generateCorsResponseParameters)(props.corsOptions)
                    : {},
                responseTemplates: {},
            },
        };
    }
}
exports.DefaultPassthroughIntegrationResponseSet = DefaultPassthroughIntegrationResponseSet;
_c = JSII_RTTI_SYMBOL_1;
DefaultPassthroughIntegrationResponseSet[_c] = { fqn: "@aws/pdk.type_safe_api.DefaultPassthroughIntegrationResponseSet", version: "0.25.8" };
/**
 * An integration response set for S3 errors, that returns a JSON payload with the S3 error message
 */
class S3JsonErrorMessageIntegrationResponseSet extends IntegrationResponseSet {
    response(props, status) {
        return {
            [`${status}`]: {
                statusCode: `${status}`,
                responseParameters: props.corsOptions
                    ? (0, prepare_spec_1.generateCorsResponseParameters)(props.corsOptions)
                    : {},
                responseTemplates: {
                    "application/json": `#set($message = $input.body.split('<Message>')[1].split('</Message>')[0])
{"message": "$util.escapeJavaScript($message).replaceAll("\\'","'")"}
`,
                },
            },
        };
    }
    render(props) {
        return {
            ...this.response(props, 400),
            ...this.response(props, 403),
            ...this.response(props, 404),
            ...this.response(props, 500),
        };
    }
}
exports.S3JsonErrorMessageIntegrationResponseSet = S3JsonErrorMessageIntegrationResponseSet;
_d = JSII_RTTI_SYMBOL_1;
S3JsonErrorMessageIntegrationResponseSet[_d] = { fqn: "@aws/pdk.type_safe_api.S3JsonErrorMessageIntegrationResponseSet", version: "0.25.8" };
/**
 * A custom integration response set where you can specify the responses as you wish
 */
class CustomIntegrationResponseSet extends IntegrationResponseSet {
    constructor(props) {
        super();
        this.responses = props.responses;
    }
    render(props) {
        return Object.fromEntries(Object.entries(this.responses ?? {}).map(([responseStatusPattern, errorResponse]) => [
            responseStatusPattern,
            {
                ...errorResponse,
                responseParameters: {
                    ...errorResponse.responseParameters,
                    ...(props.corsOptions
                        ? (0, prepare_spec_1.generateCorsResponseParameters)(props.corsOptions)
                        : {}),
                },
            },
        ]));
    }
}
exports.CustomIntegrationResponseSet = CustomIntegrationResponseSet;
_e = JSII_RTTI_SYMBOL_1;
CustomIntegrationResponseSet[_e] = { fqn: "@aws/pdk.type_safe_api.CustomIntegrationResponseSet", version: "0.25.8" };
/**
 * An integration response set which combines the provided integration response sets.
 * Response sets are combined in order, so later responses will override previous ones for
 * overlapping response status patterns.
 */
class CompositeIntegrationResponseSet extends IntegrationResponseSet {
    constructor(...responseSets) {
        super();
        this.responseSets = responseSets;
    }
    render(props) {
        return this.responseSets.reduce((responses, responseSet) => ({
            ...responses,
            ...responseSet.render(props),
        }), {});
    }
}
exports.CompositeIntegrationResponseSet = CompositeIntegrationResponseSet;
_f = JSII_RTTI_SYMBOL_1;
CompositeIntegrationResponseSet[_f] = { fqn: "@aws/pdk.type_safe_api.CompositeIntegrationResponseSet", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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