"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationResponseSets = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const integration_response_set_1 = require("./integration-response-set");
class IntegrationResponseSets {
    /**
     * An integration response set which adds a passthrough for the default response
     */
    static defaultPassthrough(props) {
        return new integration_response_set_1.DefaultPassthroughIntegrationResponseSet(props);
    }
    /**
     * An integration response set that returns the error message from S3 in a "message" property of a JSON object
     * for 400, 403, 404 and 500 errors.
     */
    static s3JsonErrorMessage() {
        return new integration_response_set_1.S3JsonErrorMessageIntegrationResponseSet();
    }
    /**
     * An integration response set that catches all 4XX and 5XX errors and returns a 500
     */
    static catchAll() {
        return new integration_response_set_1.CatchAllErrorIntegrationResponseSet();
    }
    /**
     * A custom integration response set where you can specify the responses as you wish
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-integration-settings-integration-response.html
     */
    static custom(props) {
        return new integration_response_set_1.CustomIntegrationResponseSet(props);
    }
    /**
     * Combine the provided integration response sets.
     * Response sets are combined in order, so later responses will override previous ones for
     * overlapping response status patterns.
     */
    static composite(...responseSets) {
        return new integration_response_set_1.CompositeIntegrationResponseSet(...responseSets);
    }
}
exports.IntegrationResponseSets = IntegrationResponseSets;
_a = JSII_RTTI_SYMBOL_1;
IntegrationResponseSets[_a] = { fqn: "@aws/pdk.type_safe_api.IntegrationResponseSets", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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