"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Integrations = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda_1 = require("./lambda");
const mock_1 = require("./mock");
const s3_1 = require("./s3");
/**
 * A collection of integrations to connect API operations with a backend to service requests
 */
class Integrations {
    /**
     * An integration that invokes a lambda function to service the request
     * @param lambdaFunction the function to invoke
     */
    static lambda(lambdaFunction) {
        return new lambda_1.LambdaIntegration(lambdaFunction);
    }
    /**
     * An integration that returns a hardcoded response
     * @param response the response to return
     */
    static mock(response) {
        return new mock_1.MockIntegration(response);
    }
    /**
     * An integration that can read/write to an S3 bucket
     * @param props the integration props
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html
     */
    static s3(props) {
        return new s3_1.S3Integration(props);
    }
}
exports.Integrations = Integrations;
_a = JSII_RTTI_SYMBOL_1;
Integrations[_a] = { fqn: "@aws/pdk.type_safe_api.Integrations", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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