import { Project } from "projen";
import { Language, Library, WebSocketLibrary } from "../../languages";
import { MockResponseDataGenerationOptions } from "../../types";
import { GeneratedHandlersProjects } from "../generate";
/**
 * Enum for generator directories for non-runtime generators
 */
export declare enum OtherGenerators {
    TYPESCRIPT_CDK_INFRASTRUCTURE = "typescript-cdk-infrastructure",
    PYTHON_CDK_INFRASTRUCTURE = "python-cdk-infrastructure",
    JAVA_CDK_INFRASTRUCTURE = "java-cdk-infrastructure",
    TYPESCRIPT_ASYNC_CDK_INFRASTRUCTURE = "typescript-async-cdk-infrastructure",
    PYTHON_ASYNC_CDK_INFRASTRUCTURE = "python-async-cdk-infrastructure",
    JAVA_ASYNC_CDK_INFRASTRUCTURE = "java-async-cdk-infrastructure",
    TYPESCRIPT_LAMBDA_HANDLERS = "typescript-lambda-handlers",
    PYTHON_LAMBDA_HANDLERS = "python-lambda-handlers",
    JAVA_LAMBDA_HANDLERS = "java-lambda-handlers",
    TYPESCRIPT_ASYNC_LAMBDA_HANDLERS = "typescript-async-lambda-handlers",
    PYTHON_ASYNC_LAMBDA_HANDLERS = "python-async-lambda-handlers",
    JAVA_ASYNC_LAMBDA_HANDLERS = "java-async-lambda-handlers",
    TYPESCRIPT_ASYNC_RUNTIME = "typescript-async-runtime",
    PYTHON_ASYNC_RUNTIME = "python-async-runtime",
    JAVA_ASYNC_RUNTIME = "java-async-runtime"
}
/**
 * Built in scripts.
 * If adding a script here, ensure you map it in TypeSafeApiProject (in /projenrc/projects)
 */
export declare enum TypeSafeApiScript {
    PARSE_OPENAPI_SPEC = "type-safe-api parse-openapi-spec",
    GENERATE = "type-safe-api generate",
    GENERATE_MOCK_DATA = "type-safe-api generate-mock-data",
    COPY_GRADLE_WRAPPER = "type-safe-api copy-gradle-wrapper",
    COPY_ASYNC_SMITHY_TRANSFORMER = "type-safe-api copy-async-smithy-transformer",
    GENERATE_ASYNCAPI_SPEC = "type-safe-api generate-asyncapi-spec"
}
/**
 * Generator directory for openapi generation containing templates, config etc.
 */
export type GeneratorDirectory = Language | Library | WebSocketLibrary | OtherGenerators;
export interface CodegenOptions {
    readonly specPath: string;
    readonly templateDirs: string[];
    readonly metadata?: object;
}
/**
 * Return the environment that should be used for executing type safe api commands
 */
export declare const getTypeSafeApiTaskEnvironment: () => {
    [key: string]: string;
};
/**
 * Build a command for running a script from this project's bin
 */
export declare const buildTypeSafeApiExecCommand: (script: TypeSafeApiScript, args?: string) => string;
export declare const buildCodegenCommandArgs: (options: CodegenOptions) => string;
/**
 * Options for generating mock data json files
 */
export interface MockDataGenerationOptions extends MockResponseDataGenerationOptions {
    /**
     * The path of the OpenAPI spec to generate data for
     */
    readonly specPath: string;
    /**
     * Output sub directory relative to the outdir in which to generate mock data
     * Mock data will be written to a directory named 'mocks' within the sub directory
     * @default .
     */
    readonly outputSubDir?: string;
}
/**
 * Invoke the mock data generator script
 */
export declare const buildInvokeMockDataGeneratorCommand: (options: MockDataGenerationOptions) => string;
/**
 * Return vendor extensions containing details about the handler projects
 */
export declare const getHandlersProjectVendorExtensions: (targetProject: Project, { java, python, typescript }: GeneratedHandlersProjects) => Record<string, string | boolean>;
