"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedHtmlRedocDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
class GeneratedHtmlRedocDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec(`npx --yes @redocly/cli@1.25.4 build-docs "${options.specPath}" --output ./index.html`);
        this.compileTask.spawn(this.generateTask);
        if (!options.commitGeneratedCode) {
            this.gitignore.addPatterns("index.html");
        }
    }
}
exports.GeneratedHtmlRedocDocumentationProject = GeneratedHtmlRedocDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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