"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedMarkdownDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
const utils_1 = require("../components/utils");
class GeneratedMarkdownDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE, (0, utils_1.buildCodegenCommandArgs)({
            specPath: options.specPath,
            templateDirs: ["docs/templates/markdown"],
        })));
        this.compileTask.spawn(this.generateTask);
        if (!options.commitGeneratedCode) {
            this.gitignore.addPatterns("Apis", "Models", "README.md");
        }
        this.gitignore.addPatterns(".openapi-generator", ".tsapi-manifest");
    }
}
exports.GeneratedMarkdownDocumentationProject = GeneratedMarkdownDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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