import { JavaProject } from "projen/lib/java";
import { JavaVersion } from "../../languages";
import { CodeGenerationSourceOptions, GeneratedJavaHandlersOptions } from "../../types";
import { CodegenOptions } from "../components/utils";
import { GeneratedJavaRuntimeBaseProject } from "../runtime/generated-java-runtime-base-project";
export interface GeneratedJavaHandlersBaseProjectOptions extends GeneratedJavaHandlersOptions, CodeGenerationSourceOptions {
    /**
     * The generated java types
     */
    readonly generatedJavaTypes: GeneratedJavaRuntimeBaseProject;
}
export declare abstract class GeneratedJavaHandlersBaseProject extends JavaProject {
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedJavaHandlersBaseProjectOptions;
    /**
     * Source directory
     */
    protected readonly srcDir: string;
    /**
     * Test directory
     */
    protected readonly tstDir: string;
    /**
     * Java package name
     */
    readonly packageName: string;
    /**
     * Java runtime version for the handlers
     */
    readonly runtimeVersion: JavaVersion;
    constructor(options: GeneratedJavaHandlersBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    abstract buildCodegenOptions(): CodegenOptions;
}
