import { Task } from "projen";
import { JavaProject, JavaProjectOptions } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedProjectOptions } from "../../../types";
import { CodegenOptions } from "../../components/utils";
import { GeneratedHandlersProjects } from "../../generate";
import { GeneratedJavaRuntimeBaseProject } from "../../runtime/generated-java-runtime-base-project";
export interface GeneratedJavaInfrastructureBaseOptions extends JavaProjectOptions, GeneratedProjectOptions {
}
export interface GeneratedJavaCdkInfrastructureBaseProjectOptions extends GeneratedJavaInfrastructureBaseOptions, CodeGenerationSourceOptions {
    /**
     * The generated java types
     */
    readonly generatedJavaTypes: GeneratedJavaRuntimeBaseProject;
    /**
     * Generated handlers projects
     */
    readonly generatedHandlers: GeneratedHandlersProjects;
}
export declare abstract class GeneratedJavaCdkInfrastructureBaseProject extends JavaProject {
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedJavaCdkInfrastructureBaseProjectOptions;
    /**
     * Source directory
     */
    protected readonly srcDir: string;
    /**
     * Java package name
     */
    protected readonly packageName: string;
    /**
     * Code generation task
     */
    protected readonly generateTask: Task;
    constructor(options: GeneratedJavaCdkInfrastructureBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildCodegenOptions(): CodegenOptions;
}
