"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaCdkInfrastructureBaseProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const monorepo_1 = require("../../../../../monorepo");
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const type_safe_api_command_environment_1 = require("../../components/type-safe-api-command-environment");
const utils_1 = require("../../components/utils");
class GeneratedJavaCdkInfrastructureBaseProject extends java_1.JavaProject {
    constructor(options) {
        super({
            ...options,
            sample: false,
            junit: false,
        });
        this.buildGenerateCommandArgs = () => {
            return (0, utils_1.buildCodegenCommandArgs)(this.buildCodegenOptions());
        };
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.options = options;
        this.packageName = `${this.pom.groupId}.${this.name}.infra`;
        this.srcDir = path.join("src", "main", "java", ...this.packageName.split("."));
        [
            `software.aws/pdk@${monorepo_1.ProjectUtils.getPdkVersion()}`,
            "software.constructs/constructs@10.3.0",
            "software.amazon.awscdk/aws-cdk-lib@2.133.0",
            "io.github.cdklabs/cdknag@2.28.60",
            "org.projectlombok/lombok@1.18.30",
            "com.fasterxml.jackson.core/jackson-databind@2.17.0",
            `io.github.cdklabs/projen@0.80.10`,
            `${options.generatedJavaTypes.pom.groupId}/${options.generatedJavaTypes.pom.artifactId}@${options.generatedJavaTypes.pom.version}`,
        ]
            .filter((dep) => !this.deps.tryGetDependency(dep.split("@")[0], projen_1.DependencyType.RUNTIME))
            .forEach((dep) => this.addDependency(dep));
        // Pin constructs version
        this.deps.removeDependency("software.constructs/constructs", projen_1.DependencyType.BUILD);
        this.addDependency("software.constructs/constructs@10.3.0");
        // Remove the projen test dependency since otherwise it takes precedence, causing projen to be unavailable at synth time
        this.deps.removeDependency("io.github.cdklabs/projen", projen_1.DependencyType.TEST);
        // Add a dependency on the generated java types repository
        this.pom.addRepository({
            url: `file://${path.relative(this.outdir, options.generatedJavaTypes.outdir)}/dist/java`,
            id: `${options.generatedJavaTypes.pom.groupId}-${options.generatedJavaTypes.pom.artifactId}-repo`,
        });
        const generateTask = this.addTask("generate");
        this.generateTask = generateTask;
        generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE, this.buildGenerateCommandArgs()));
        // Copy the parsed spec into the resources directory so that it's included in the jar
        generateTask.exec("mkdir -p src/main/resources");
        generateTask.exec(`cp -f ${this.options.specPath} src/main/resources/.api.json`);
        // Absolute path of this project is required for determining the path to the handlers jar,
        // since java executes from the jar which could be anywhere in the filesystem (eg the .m2 directory).
        // While ugly, since this is written at build time and not checked in it remains portable.
        generateTask.exec("echo $(pwd) > src/main/resources/project-absolute-path.txt");
        this.gitignore.addPatterns(".tsapi-manifest", ".openapi-generator");
        this.preCompileTask.spawn(generateTask);
    }
}
exports.GeneratedJavaCdkInfrastructureBaseProject = GeneratedJavaCdkInfrastructureBaseProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2VuZXJhdGVkLWphdmEtY2RrLWluZnJhc3RydWN0dXJlLWJhc2UtcHJvamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdlbmVyYXRlZC1qYXZhLWNkay1pbmZyYXN0cnVjdHVyZS1iYXNlLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7c0NBQ3NDO0FBQ3RDLDZCQUE2QjtBQUM3Qiw0Q0FBNkM7QUFDN0MsbUNBQThDO0FBQzlDLDBDQUFrRTtBQUtsRSwwR0FBbUc7QUFDbkcsa0RBS2dDO0FBcUJoQyxNQUFzQix5Q0FBMEMsU0FBUSxrQkFBVztJQXFCakYsWUFBWSxPQUF5RDtRQUNuRSxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFDVixNQUFNLEVBQUUsS0FBSztZQUNiLEtBQUssRUFBRSxLQUFLO1NBQ2IsQ0FBQyxDQUFDO1FBd0VFLDZCQUF3QixHQUFHLEdBQUcsRUFBRTtZQUNyQyxPQUFPLElBQUEsK0JBQXVCLEVBQUMsSUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUMsQ0FBQztRQUM3RCxDQUFDLENBQUM7UUF6RUEsaUVBQTZCLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRTNDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxXQUFXLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsSUFBSSxRQUFRLENBQUM7UUFDNUQsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUNyQixLQUFLLEVBQ0wsTUFBTSxFQUNOLE1BQU0sRUFDTixHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUMvQixDQUFDO1FBRUY7WUFDRSxvQkFBb0IsdUJBQVksQ0FBQyxhQUFhLEVBQUUsRUFBRTtZQUNsRCx1Q0FBdUM7WUFDdkMsNENBQTRDO1lBQzVDLGtDQUFrQztZQUNsQyxrQ0FBa0M7WUFDbEMsb0RBQW9EO1lBQ3BELGtDQUFrQztZQUNsQyxHQUFHLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsT0FBTyxJQUFJLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsVUFBVSxJQUFJLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFO1NBQ25JO2FBQ0UsTUFBTSxDQUNMLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FDTixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSx1QkFBYyxDQUFDLE9BQU8sQ0FBQyxDQUN6RTthQUNBLE9BQU8sQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRTdDLHlCQUF5QjtRQUN6QixJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUN4QixnQ0FBZ0MsRUFDaEMsdUJBQWMsQ0FBQyxLQUFLLENBQ3JCLENBQUM7UUFDRixJQUFJLENBQUMsYUFBYSxDQUFDLHVDQUF1QyxDQUFDLENBQUM7UUFFNUQsd0hBQXdIO1FBQ3hILElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsMEJBQTBCLEVBQUUsdUJBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU1RSwwREFBMEQ7UUFDMUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUM7WUFDckIsR0FBRyxFQUFFLFVBQVUsSUFBSSxDQUFDLFFBQVEsQ0FDMUIsSUFBSSxDQUFDLE1BQU0sRUFDWCxPQUFPLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUNsQyxZQUFZO1lBQ2IsRUFBRSxFQUFFLEdBQUcsT0FBTyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLGtCQUFrQixDQUFDLEdBQUcsQ0FBQyxVQUFVLE9BQU87U0FDbEcsQ0FBQyxDQUFDO1FBRUgsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztRQUNqQyxZQUFZLENBQUMsSUFBSSxDQUNmLElBQUEsbUNBQTJCLEVBQ3pCLHlCQUFpQixDQUFDLFFBQVEsRUFDMUIsSUFBSSxDQUFDLHdCQUF3QixFQUFFLENBQ2hDLENBQ0YsQ0FBQztRQUNGLHFGQUFxRjtRQUNyRixZQUFZLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDakQsWUFBWSxDQUFDLElBQUksQ0FDZixTQUFTLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSwrQkFBK0IsQ0FDOUQsQ0FBQztRQUNGLDBGQUEwRjtRQUMxRixxR0FBcUc7UUFDckcsMEZBQTBGO1FBQzFGLFlBQVksQ0FBQyxJQUFJLENBQ2YsNERBQTRELENBQzdELENBQUM7UUFFRixJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxpQkFBaUIsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBRXBFLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQzFDLENBQUM7Q0FPRjtBQXZHRCw4RkF1R0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IFByb2plY3RVdGlscyB9IGZyb20gXCJAYXdzL21vbm9yZXBvXCI7XG5pbXBvcnQgeyBEZXBlbmRlbmN5VHlwZSwgVGFzayB9IGZyb20gXCJwcm9qZW5cIjtcbmltcG9ydCB7IEphdmFQcm9qZWN0LCBKYXZhUHJvamVjdE9wdGlvbnMgfSBmcm9tIFwicHJvamVuL2xpYi9qYXZhXCI7XG5pbXBvcnQge1xuICBDb2RlR2VuZXJhdGlvblNvdXJjZU9wdGlvbnMsXG4gIEdlbmVyYXRlZFByb2plY3RPcHRpb25zLFxufSBmcm9tIFwiLi4vLi4vLi4vdHlwZXNcIjtcbmltcG9ydCB7IFR5cGVTYWZlQXBpQ29tbWFuZEVudmlyb25tZW50IH0gZnJvbSBcIi4uLy4uL2NvbXBvbmVudHMvdHlwZS1zYWZlLWFwaS1jb21tYW5kLWVudmlyb25tZW50XCI7XG5pbXBvcnQge1xuICBidWlsZENvZGVnZW5Db21tYW5kQXJncyxcbiAgYnVpbGRUeXBlU2FmZUFwaUV4ZWNDb21tYW5kLFxuICBDb2RlZ2VuT3B0aW9ucyxcbiAgVHlwZVNhZmVBcGlTY3JpcHQsXG59IGZyb20gXCIuLi8uLi9jb21wb25lbnRzL3V0aWxzXCI7XG5pbXBvcnQgeyBHZW5lcmF0ZWRIYW5kbGVyc1Byb2plY3RzIH0gZnJvbSBcIi4uLy4uL2dlbmVyYXRlXCI7XG5pbXBvcnQgeyBHZW5lcmF0ZWRKYXZhUnVudGltZUJhc2VQcm9qZWN0IH0gZnJvbSBcIi4uLy4uL3J1bnRpbWUvZ2VuZXJhdGVkLWphdmEtcnVudGltZS1iYXNlLXByb2plY3RcIjtcblxuZXhwb3J0IGludGVyZmFjZSBHZW5lcmF0ZWRKYXZhSW5mcmFzdHJ1Y3R1cmVCYXNlT3B0aW9uc1xuICBleHRlbmRzIEphdmFQcm9qZWN0T3B0aW9ucyxcbiAgICBHZW5lcmF0ZWRQcm9qZWN0T3B0aW9ucyB7fVxuXG5leHBvcnQgaW50ZXJmYWNlIEdlbmVyYXRlZEphdmFDZGtJbmZyYXN0cnVjdHVyZUJhc2VQcm9qZWN0T3B0aW9uc1xuICBleHRlbmRzIEdlbmVyYXRlZEphdmFJbmZyYXN0cnVjdHVyZUJhc2VPcHRpb25zLFxuICAgIENvZGVHZW5lcmF0aW9uU291cmNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgZ2VuZXJhdGVkIGphdmEgdHlwZXNcbiAgICovXG4gIHJlYWRvbmx5IGdlbmVyYXRlZEphdmFUeXBlczogR2VuZXJhdGVkSmF2YVJ1bnRpbWVCYXNlUHJvamVjdDtcbiAgLyoqXG4gICAqIEdlbmVyYXRlZCBoYW5kbGVycyBwcm9qZWN0c1xuICAgKi9cbiAgcmVhZG9ubHkgZ2VuZXJhdGVkSGFuZGxlcnM6IEdlbmVyYXRlZEhhbmRsZXJzUHJvamVjdHM7XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBHZW5lcmF0ZWRKYXZhQ2RrSW5mcmFzdHJ1Y3R1cmVCYXNlUHJvamVjdCBleHRlbmRzIEphdmFQcm9qZWN0IHtcbiAgLyoqXG4gICAqIE9wdGlvbnMgY29uZmlndXJlZCBmb3IgdGhlIHByb2plY3RcbiAgICovXG4gIHByb3RlY3RlZCByZWFkb25seSBvcHRpb25zOiBHZW5lcmF0ZWRKYXZhQ2RrSW5mcmFzdHJ1Y3R1cmVCYXNlUHJvamVjdE9wdGlvbnM7XG5cbiAgLyoqXG4gICAqIFNvdXJjZSBkaXJlY3RvcnlcbiAgICovXG4gIHByb3RlY3RlZCByZWFkb25seSBzcmNEaXI6IHN0cmluZztcblxuICAvKipcbiAgICogSmF2YSBwYWNrYWdlIG5hbWVcbiAgICovXG4gIHByb3RlY3RlZCByZWFkb25seSBwYWNrYWdlTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDb2RlIGdlbmVyYXRpb24gdGFza1xuICAgKi9cbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGdlbmVyYXRlVGFzazogVGFzaztcblxuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBHZW5lcmF0ZWRKYXZhQ2RrSW5mcmFzdHJ1Y3R1cmVCYXNlUHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgc2FtcGxlOiBmYWxzZSxcbiAgICAgIGp1bml0OiBmYWxzZSxcbiAgICB9KTtcbiAgICBUeXBlU2FmZUFwaUNvbW1hbmRFbnZpcm9ubWVudC5lbnN1cmUodGhpcyk7XG5cbiAgICB0aGlzLm9wdGlvbnMgPSBvcHRpb25zO1xuICAgIHRoaXMucGFja2FnZU5hbWUgPSBgJHt0aGlzLnBvbS5ncm91cElkfS4ke3RoaXMubmFtZX0uaW5mcmFgO1xuICAgIHRoaXMuc3JjRGlyID0gcGF0aC5qb2luKFxuICAgICAgXCJzcmNcIixcbiAgICAgIFwibWFpblwiLFxuICAgICAgXCJqYXZhXCIsXG4gICAgICAuLi50aGlzLnBhY2thZ2VOYW1lLnNwbGl0KFwiLlwiKVxuICAgICk7XG5cbiAgICBbXG4gICAgICBgc29mdHdhcmUuYXdzL3Bka0Ake1Byb2plY3RVdGlscy5nZXRQZGtWZXJzaW9uKCl9YCxcbiAgICAgIFwic29mdHdhcmUuY29uc3RydWN0cy9jb25zdHJ1Y3RzQDEwLjMuMFwiLFxuICAgICAgXCJzb2Z0d2FyZS5hbWF6b24uYXdzY2RrL2F3cy1jZGstbGliQDIuMTMzLjBcIixcbiAgICAgIFwiaW8uZ2l0aHViLmNka2xhYnMvY2RrbmFnQDIuMjguNjBcIixcbiAgICAgIFwib3JnLnByb2plY3Rsb21ib2svbG9tYm9rQDEuMTguMzBcIixcbiAgICAgIFwiY29tLmZhc3RlcnhtbC5qYWNrc29uLmNvcmUvamFja3Nvbi1kYXRhYmluZEAyLjE3LjBcIixcbiAgICAgIGBpby5naXRodWIuY2RrbGFicy9wcm9qZW5AMC44MC4xMGAsXG4gICAgICBgJHtvcHRpb25zLmdlbmVyYXRlZEphdmFUeXBlcy5wb20uZ3JvdXBJZH0vJHtvcHRpb25zLmdlbmVyYXRlZEphdmFUeXBlcy5wb20uYXJ0aWZhY3RJZH1AJHtvcHRpb25zLmdlbmVyYXRlZEphdmFUeXBlcy5wb20udmVyc2lvbn1gLFxuICAgIF1cbiAgICAgIC5maWx0ZXIoXG4gICAgICAgIChkZXApID0+XG4gICAgICAgICAgIXRoaXMuZGVwcy50cnlHZXREZXBlbmRlbmN5KGRlcC5zcGxpdChcIkBcIilbMF0sIERlcGVuZGVuY3lUeXBlLlJVTlRJTUUpXG4gICAgICApXG4gICAgICAuZm9yRWFjaCgoZGVwKSA9PiB0aGlzLmFkZERlcGVuZGVuY3koZGVwKSk7XG5cbiAgICAvLyBQaW4gY29uc3RydWN0cyB2ZXJzaW9uXG4gICAgdGhpcy5kZXBzLnJlbW92ZURlcGVuZGVuY3koXG4gICAgICBcInNvZnR3YXJlLmNvbnN0cnVjdHMvY29uc3RydWN0c1wiLFxuICAgICAgRGVwZW5kZW5jeVR5cGUuQlVJTERcbiAgICApO1xuICAgIHRoaXMuYWRkRGVwZW5kZW5jeShcInNvZnR3YXJlLmNvbnN0cnVjdHMvY29uc3RydWN0c0AxMC4zLjBcIik7XG5cbiAgICAvLyBSZW1vdmUgdGhlIHByb2plbiB0ZXN0IGRlcGVuZGVuY3kgc2luY2Ugb3RoZXJ3aXNlIGl0IHRha2VzIHByZWNlZGVuY2UsIGNhdXNpbmcgcHJvamVuIHRvIGJlIHVuYXZhaWxhYmxlIGF0IHN5bnRoIHRpbWVcbiAgICB0aGlzLmRlcHMucmVtb3ZlRGVwZW5kZW5jeShcImlvLmdpdGh1Yi5jZGtsYWJzL3Byb2plblwiLCBEZXBlbmRlbmN5VHlwZS5URVNUKTtcblxuICAgIC8vIEFkZCBhIGRlcGVuZGVuY3kgb24gdGhlIGdlbmVyYXRlZCBqYXZhIHR5cGVzIHJlcG9zaXRvcnlcbiAgICB0aGlzLnBvbS5hZGRSZXBvc2l0b3J5KHtcbiAgICAgIHVybDogYGZpbGU6Ly8ke3BhdGgucmVsYXRpdmUoXG4gICAgICAgIHRoaXMub3V0ZGlyLFxuICAgICAgICBvcHRpb25zLmdlbmVyYXRlZEphdmFUeXBlcy5vdXRkaXJcbiAgICAgICl9L2Rpc3QvamF2YWAsXG4gICAgICBpZDogYCR7b3B0aW9ucy5nZW5lcmF0ZWRKYXZhVHlwZXMucG9tLmdyb3VwSWR9LSR7b3B0aW9ucy5nZW5lcmF0ZWRKYXZhVHlwZXMucG9tLmFydGlmYWN0SWR9LXJlcG9gLFxuICAgIH0pO1xuXG4gICAgY29uc3QgZ2VuZXJhdGVUYXNrID0gdGhpcy5hZGRUYXNrKFwiZ2VuZXJhdGVcIik7XG4gICAgdGhpcy5nZW5lcmF0ZVRhc2sgPSBnZW5lcmF0ZVRhc2s7XG4gICAgZ2VuZXJhdGVUYXNrLmV4ZWMoXG4gICAgICBidWlsZFR5cGVTYWZlQXBpRXhlY0NvbW1hbmQoXG4gICAgICAgIFR5cGVTYWZlQXBpU2NyaXB0LkdFTkVSQVRFLFxuICAgICAgICB0aGlzLmJ1aWxkR2VuZXJhdGVDb21tYW5kQXJncygpXG4gICAgICApXG4gICAgKTtcbiAgICAvLyBDb3B5IHRoZSBwYXJzZWQgc3BlYyBpbnRvIHRoZSByZXNvdXJjZXMgZGlyZWN0b3J5IHNvIHRoYXQgaXQncyBpbmNsdWRlZCBpbiB0aGUgamFyXG4gICAgZ2VuZXJhdGVUYXNrLmV4ZWMoXCJta2RpciAtcCBzcmMvbWFpbi9yZXNvdXJjZXNcIik7XG4gICAgZ2VuZXJhdGVUYXNrLmV4ZWMoXG4gICAgICBgY3AgLWYgJHt0aGlzLm9wdGlvbnMuc3BlY1BhdGh9IHNyYy9tYWluL3Jlc291cmNlcy8uYXBpLmpzb25gXG4gICAgKTtcbiAgICAvLyBBYnNvbHV0ZSBwYXRoIG9mIHRoaXMgcHJvamVjdCBpcyByZXF1aXJlZCBmb3IgZGV0ZXJtaW5pbmcgdGhlIHBhdGggdG8gdGhlIGhhbmRsZXJzIGphcixcbiAgICAvLyBzaW5jZSBqYXZhIGV4ZWN1dGVzIGZyb20gdGhlIGphciB3aGljaCBjb3VsZCBiZSBhbnl3aGVyZSBpbiB0aGUgZmlsZXN5c3RlbSAoZWcgdGhlIC5tMiBkaXJlY3RvcnkpLlxuICAgIC8vIFdoaWxlIHVnbHksIHNpbmNlIHRoaXMgaXMgd3JpdHRlbiBhdCBidWlsZCB0aW1lIGFuZCBub3QgY2hlY2tlZCBpbiBpdCByZW1haW5zIHBvcnRhYmxlLlxuICAgIGdlbmVyYXRlVGFzay5leGVjKFxuICAgICAgXCJlY2hvICQocHdkKSA+IHNyYy9tYWluL3Jlc291cmNlcy9wcm9qZWN0LWFic29sdXRlLXBhdGgudHh0XCJcbiAgICApO1xuXG4gICAgdGhpcy5naXRpZ25vcmUuYWRkUGF0dGVybnMoXCIudHNhcGktbWFuaWZlc3RcIiwgXCIub3BlbmFwaS1nZW5lcmF0b3JcIik7XG5cbiAgICB0aGlzLnByZUNvbXBpbGVUYXNrLnNwYXduKGdlbmVyYXRlVGFzayk7XG4gIH1cblxuICBwdWJsaWMgYnVpbGRHZW5lcmF0ZUNvbW1hbmRBcmdzID0gKCkgPT4ge1xuICAgIHJldHVybiBidWlsZENvZGVnZW5Db21tYW5kQXJncyh0aGlzLmJ1aWxkQ29kZWdlbk9wdGlvbnMoKSk7XG4gIH07XG5cbiAgcHJvdGVjdGVkIGFic3RyYWN0IGJ1aWxkQ29kZWdlbk9wdGlvbnMoKTogQ29kZWdlbk9wdGlvbnM7XG59XG4iXX0=