"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_java_cdk_infrastructure_base_project_1 = require("./generated-java-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedJavaCdkInfrastructureProject extends generated_java_cdk_infrastructure_base_project_1.GeneratedJavaCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
        this.buildGenerateMockDataCommand = () => {
            return (0, utils_1.buildInvokeMockDataGeneratorCommand)({
                specPath: this.options.specPath,
                // Write the mocks to the resources directory
                outputSubDir: "src/main/resources",
                ...this.options.mockDataOptions,
            });
        };
        this.options = options;
        if (!this.options.mockDataOptions?.disable) {
            this.generateTask.exec(this.buildGenerateMockDataCommand());
        }
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [utils_1.OtherGenerators.JAVA_CDK_INFRASTRUCTURE],
            metadata: {
                srcDir: this.srcDir,
                packageName: this.packageName,
                runtimePackageName: this.options.generatedJavaTypes.packageName,
                enableMockIntegrations: !this.options.mockDataOptions?.disable,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedJavaCdkInfrastructureProject = GeneratedJavaCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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