"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonAsyncCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_python_cdk_infrastructure_base_project_1 = require("./generated-python-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedPythonAsyncCdkInfrastructureProject extends generated_python_cdk_infrastructure_base_project_1.GeneratedPythonCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [utils_1.OtherGenerators.PYTHON_ASYNC_CDK_INFRASTRUCTURE],
            metadata: {
                srcDir: this.moduleName,
                runtimeModuleName: this.options.generatedPythonTypes.moduleName,
                relativeSpecPath: path.join("..", this.options.specPath),
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedPythonAsyncCdkInfrastructureProject = GeneratedPythonAsyncCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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