"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_java_runtime_base_project_1 = require("./generated-java-runtime-base-project");
const languages_1 = require("../../languages");
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
class GeneratedJavaRuntimeProject extends generated_java_runtime_base_project_1.GeneratedJavaRuntimeBaseProject {
    constructor(options) {
        super(options);
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [
                // TODO: when implemented, swap to OtherGenerators.JAVA_ASYNC_RUNTIME and "java/templates/client/models"
                languages_1.Language.JAVA,
            ],
            metadata: {
                groupId: this.pom.groupId,
                artifactId: this.pom.artifactId,
                artifactVersion: this.pom.version,
                packageName: this.packageName,
                srcDir: path.join("src", "main", "java", ...this.packageName.split(".")),
            },
        };
    }
}
exports.GeneratedJavaRuntimeProject = GeneratedJavaRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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