"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketDocumentationFormat = exports.DocumentationFormat = exports.WebSocketLibrary = exports.Library = exports.PythonVersion = exports.JavaVersion = exports.NodeVersion = exports.Language = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for runtimes and infrastructure
 */
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["JAVA"] = "java";
})(Language || (exports.Language = Language = {}));
/**
 * Versions of node
 */
var NodeVersion;
(function (NodeVersion) {
    NodeVersion["NODE_18"] = "NODE_18";
    NodeVersion["NODE_20"] = "NODE_20";
})(NodeVersion || (exports.NodeVersion = NodeVersion = {}));
/**
 * Versions of java
 */
var JavaVersion;
(function (JavaVersion) {
    JavaVersion["JAVA_8"] = "JAVA_8";
    JavaVersion["JAVA_11"] = "JAVA_11";
    JavaVersion["JAVA_17"] = "JAVA_17";
    JavaVersion["JAVA_21"] = "JAVA_21";
})(JavaVersion || (exports.JavaVersion = JavaVersion = {}));
/**
 * Versions of python
 */
var PythonVersion;
(function (PythonVersion) {
    PythonVersion["PYTHON_3_11"] = "PYTHON_3_11";
    PythonVersion["PYTHON_3_12"] = "PYTHON_3_12";
})(PythonVersion || (exports.PythonVersion = PythonVersion = {}));
/**
 * Supported libraries for code generation
 */
var Library;
(function (Library) {
    Library["TYPESCRIPT_REACT_QUERY_HOOKS"] = "typescript-react-query-hooks";
})(Library || (exports.Library = Library = {}));
var WebSocketLibrary;
(function (WebSocketLibrary) {
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_CLIENT"] = "typescript-websocket-client";
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_HOOKS"] = "typescript-websocket-hooks";
})(WebSocketLibrary || (exports.WebSocketLibrary = WebSocketLibrary = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * Markdown documentation
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * PlantUML schema diagrams
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat || (exports.DocumentationFormat = DocumentationFormat = {}));
/**
 * Formats for WebSocket documentation generation
 */
var WebSocketDocumentationFormat;
(function (WebSocketDocumentationFormat) {
    /**
     * HTML Documentation generated by AsyncAPI's HTML Template
     * @see https://github.com/asyncapi/html-template
     */
    WebSocketDocumentationFormat["HTML"] = "html_asyncapi";
    /**
     * Markdown Documentation generated by AsyncAPI's Markdown Template
     * @see https://github.com/asyncapi/markdown-template
     */
    WebSocketDocumentationFormat["MARKDOWN"] = "markdown_asyncapi";
})(WebSocketDocumentationFormat || (exports.WebSocketDocumentationFormat = WebSocketDocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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