"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelReadme = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
/**
 * README.md file for a model project
 */
class ModelReadme extends projen_1.SampleFile {
    constructor(project, options) {
        super(project, "README.md", {
            sourcePath: path.resolve(__dirname, "..", "..", "..", "samples", "type-safe-api", "readme", `model-${options.apiType}`, `${options.modelLanguage}.md`),
        });
    }
}
exports.ModelReadme = ModelReadme;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kZWwtcmVhZG1lLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibW9kZWwtcmVhZG1lLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBO3NDQUNzQztBQUN0Qyw2QkFBNkI7QUFDN0IsbUNBQTZDO0FBaUI3Qzs7R0FFRztBQUNILE1BQWEsV0FBWSxTQUFRLG1CQUFVO0lBQ3pDLFlBQVksT0FBZ0IsRUFBRSxPQUEyQjtRQUN2RCxLQUFLLENBQUMsT0FBTyxFQUFFLFdBQVcsRUFBRTtZQUMxQixVQUFVLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FDdEIsU0FBUyxFQUNULElBQUksRUFDSixJQUFJLEVBQ0osSUFBSSxFQUNKLFNBQVMsRUFDVCxlQUFlLEVBQ2YsUUFBUSxFQUNSLFNBQVMsT0FBTyxDQUFDLE9BQU8sRUFBRSxFQUMxQixHQUFHLE9BQU8sQ0FBQyxhQUFhLEtBQUssQ0FDOUI7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFoQkQsa0NBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgeyBQcm9qZWN0LCBTYW1wbGVGaWxlIH0gZnJvbSBcInByb2plblwiO1xuaW1wb3J0IHsgTW9kZWxMYW5ndWFnZSB9IGZyb20gXCIuLi90eXBlc1wiO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIHRoZSBtb2RlbCByZWFkbWVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNb2RlbFJlYWRtZU9wdGlvbnMge1xuICAvKipcbiAgICogTGFuZ3VhZ2UgZm9yIHRoZSBtb2RlbFxuICAgKi9cbiAgcmVhZG9ubHkgbW9kZWxMYW5ndWFnZTogTW9kZWxMYW5ndWFnZTtcbiAgLyoqXG4gICAqIFR5cGUgb2YgQVBJXG4gICAqL1xuICByZWFkb25seSBhcGlUeXBlOiBcInJlc3RcIiB8IFwiYXN5bmNcIjtcbn1cblxuLyoqXG4gKiBSRUFETUUubWQgZmlsZSBmb3IgYSBtb2RlbCBwcm9qZWN0XG4gKi9cbmV4cG9ydCBjbGFzcyBNb2RlbFJlYWRtZSBleHRlbmRzIFNhbXBsZUZpbGUge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBNb2RlbFJlYWRtZU9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0LCBcIlJFQURNRS5tZFwiLCB7XG4gICAgICBzb3VyY2VQYXRoOiBwYXRoLnJlc29sdmUoXG4gICAgICAgIF9fZGlybmFtZSxcbiAgICAgICAgXCIuLlwiLFxuICAgICAgICBcIi4uXCIsXG4gICAgICAgIFwiLi5cIixcbiAgICAgICAgXCJzYW1wbGVzXCIsXG4gICAgICAgIFwidHlwZS1zYWZlLWFwaVwiLFxuICAgICAgICBcInJlYWRtZVwiLFxuICAgICAgICBgbW9kZWwtJHtvcHRpb25zLmFwaVR5cGV9YCxcbiAgICAgICAgYCR7b3B0aW9ucy5tb2RlbExhbmd1YWdlfS5tZGBcbiAgICAgICksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==