"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiAsyncModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_async_definition_1 = require("./open-api-async-definition");
const type_safe_api_command_environment_1 = require("../../codegen/components/type-safe-api-command-environment");
const types_1 = require("../../types");
const model_readme_1 = require("../model-readme");
const type_safe_api_async_model_build_1 = require("../type-safe-api-async-model-build");
const type_safe_api_model_build_1 = require("../type-safe-api-model-build");
/**
 * Project for defining an OpenAPI model for a WebSocket API
 */
class OpenApiAsyncModelProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.definition = new open_api_async_definition_1.OpenApiAsyncDefinition(this, options);
        this.apiName = options.openApiOptions.title;
        new type_safe_api_model_build_1.TypeSafeApiModelBuild(this, {
            openApiSpecificationPath: this.definition.openApiSpecificationPath,
            parsedSpecFile: options.parsedSpecFile,
        });
        new type_safe_api_async_model_build_1.TypeSafeApiAsyncModelBuild(this, {
            parsedSpecFile: options.parsedSpecFile,
            asyncApiSpecFile: options.asyncApiSpecFile,
        });
        new model_readme_1.ModelReadme(this, {
            modelLanguage: types_1.ModelLanguage.OPENAPI,
            apiType: "async",
        });
    }
}
exports.OpenApiAsyncModelProject = OpenApiAsyncModelProject;
_a = JSII_RTTI_SYMBOL_1;
OpenApiAsyncModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiAsyncModelProject", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktYXN5bmMtbW9kZWwtcHJvamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm9wZW4tYXBpLWFzeW5jLW1vZGVsLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQTtzQ0FDc0M7QUFDdEMsbUNBQWlEO0FBQ2pELDJFQUdxQztBQUNyQyxrSEFBMkc7QUFDM0csdUNBQTRDO0FBQzVDLGtEQUE4QztBQUM5Qyx3RkFHNEM7QUFDNUMsNEVBR3NDO0FBV3RDOztHQUVHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSxnQkFBTztJQVVuRCxZQUFZLE9BQXdDO1FBQ2xELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNmLGlFQUE2QixDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUUzQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksa0RBQXNCLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBRTVELElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUM7UUFFNUMsSUFBSSxpREFBcUIsQ0FBQyxJQUFJLEVBQUU7WUFDOUIsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyx3QkFBd0I7WUFDbEUsY0FBYyxFQUFFLE9BQU8sQ0FBQyxjQUFjO1NBQ3ZDLENBQUMsQ0FBQztRQUVILElBQUksNERBQTBCLENBQUMsSUFBSSxFQUFFO1lBQ25DLGNBQWMsRUFBRSxPQUFPLENBQUMsY0FBYztZQUN0QyxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsZ0JBQWdCO1NBQzNDLENBQUMsQ0FBQztRQUVILElBQUksMEJBQVcsQ0FBQyxJQUFJLEVBQUU7WUFDcEIsYUFBYSxFQUFFLHFCQUFhLENBQUMsT0FBTztZQUNwQyxPQUFPLEVBQUUsT0FBTztTQUNqQixDQUFDLENBQUM7SUFDTCxDQUFDOztBQWhDSCw0REFpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IFByb2plY3QsIFByb2plY3RPcHRpb25zIH0gZnJvbSBcInByb2plblwiO1xuaW1wb3J0IHtcbiAgT3BlbkFwaUFzeW5jRGVmaW5pdGlvbk9wdGlvbnMsXG4gIE9wZW5BcGlBc3luY0RlZmluaXRpb24sXG59IGZyb20gXCIuL29wZW4tYXBpLWFzeW5jLWRlZmluaXRpb25cIjtcbmltcG9ydCB7IFR5cGVTYWZlQXBpQ29tbWFuZEVudmlyb25tZW50IH0gZnJvbSBcIi4uLy4uL2NvZGVnZW4vY29tcG9uZW50cy90eXBlLXNhZmUtYXBpLWNvbW1hbmQtZW52aXJvbm1lbnRcIjtcbmltcG9ydCB7IE1vZGVsTGFuZ3VhZ2UgfSBmcm9tIFwiLi4vLi4vdHlwZXNcIjtcbmltcG9ydCB7IE1vZGVsUmVhZG1lIH0gZnJvbSBcIi4uL21vZGVsLXJlYWRtZVwiO1xuaW1wb3J0IHtcbiAgVHlwZVNhZmVBcGlBc3luY01vZGVsQnVpbGQsXG4gIFR5cGVTYWZlQXBpQXN5bmNNb2RlbEJ1aWxkT3V0cHV0T3B0aW9ucyxcbn0gZnJvbSBcIi4uL3R5cGUtc2FmZS1hcGktYXN5bmMtbW9kZWwtYnVpbGRcIjtcbmltcG9ydCB7XG4gIFR5cGVTYWZlQXBpTW9kZWxCdWlsZCxcbiAgVHlwZVNhZmVBcGlNb2RlbEJ1aWxkT3V0cHV0T3B0aW9ucyxcbn0gZnJvbSBcIi4uL3R5cGUtc2FmZS1hcGktbW9kZWwtYnVpbGRcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciBhbiBPcGVuQVBJIFdlYlNvY2tldCBBUEkgbW9kZWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBPcGVuQXBpQXN5bmNNb2RlbFByb2plY3RPcHRpb25zXG4gIGV4dGVuZHMgUHJvamVjdE9wdGlvbnMsXG4gICAgT3BlbkFwaUFzeW5jRGVmaW5pdGlvbk9wdGlvbnMsXG4gICAgVHlwZVNhZmVBcGlNb2RlbEJ1aWxkT3V0cHV0T3B0aW9ucyxcbiAgICBUeXBlU2FmZUFwaUFzeW5jTW9kZWxCdWlsZE91dHB1dE9wdGlvbnMge31cblxuLyoqXG4gKiBQcm9qZWN0IGZvciBkZWZpbmluZyBhbiBPcGVuQVBJIG1vZGVsIGZvciBhIFdlYlNvY2tldCBBUElcbiAqL1xuZXhwb3J0IGNsYXNzIE9wZW5BcGlBc3luY01vZGVsUHJvamVjdCBleHRlbmRzIFByb2plY3Qge1xuICAvKipcbiAgICogTmFtZSBvZiB0aGUgQVBJXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXBpTmFtZTogc3RyaW5nO1xuICAvKipcbiAgICogT3BlbkFQSSBzcGVjaWZpY2F0aW9uIGNvbXBvbmVudFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRlZmluaXRpb246IE9wZW5BcGlBc3luY0RlZmluaXRpb247XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogT3BlbkFwaUFzeW5jTW9kZWxQcm9qZWN0T3B0aW9ucykge1xuICAgIHN1cGVyKG9wdGlvbnMpO1xuICAgIFR5cGVTYWZlQXBpQ29tbWFuZEVudmlyb25tZW50LmVuc3VyZSh0aGlzKTtcblxuICAgIHRoaXMuZGVmaW5pdGlvbiA9IG5ldyBPcGVuQXBpQXN5bmNEZWZpbml0aW9uKHRoaXMsIG9wdGlvbnMpO1xuXG4gICAgdGhpcy5hcGlOYW1lID0gb3B0aW9ucy5vcGVuQXBpT3B0aW9ucy50aXRsZTtcblxuICAgIG5ldyBUeXBlU2FmZUFwaU1vZGVsQnVpbGQodGhpcywge1xuICAgICAgb3BlbkFwaVNwZWNpZmljYXRpb25QYXRoOiB0aGlzLmRlZmluaXRpb24ub3BlbkFwaVNwZWNpZmljYXRpb25QYXRoLFxuICAgICAgcGFyc2VkU3BlY0ZpbGU6IG9wdGlvbnMucGFyc2VkU3BlY0ZpbGUsXG4gICAgfSk7XG5cbiAgICBuZXcgVHlwZVNhZmVBcGlBc3luY01vZGVsQnVpbGQodGhpcywge1xuICAgICAgcGFyc2VkU3BlY0ZpbGU6IG9wdGlvbnMucGFyc2VkU3BlY0ZpbGUsXG4gICAgICBhc3luY0FwaVNwZWNGaWxlOiBvcHRpb25zLmFzeW5jQXBpU3BlY0ZpbGUsXG4gICAgfSk7XG5cbiAgICBuZXcgTW9kZWxSZWFkbWUodGhpcywge1xuICAgICAgbW9kZWxMYW5ndWFnZTogTW9kZWxMYW5ndWFnZS5PUEVOQVBJLFxuICAgICAgYXBpVHlwZTogXCJhc3luY1wiLFxuICAgIH0pO1xuICB9XG59XG4iXX0=