"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_project_definition_1 = require("./open-api-project-definition");
/**
 * The OpenAPI Spec
 */
class OpenApiDefinition extends open_api_project_definition_1.OpenApiProjectDefinition {
    constructor(project, options) {
        super(project, options);
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create a sample OpenAPI spec yaml if not defined
        new projen_1.SampleFile(project, this.openApiSpecificationPath, {
            contents: `openapi: 3.0.3
info:
  version: 1.0.0
  title: ${options.openApiOptions.title}
paths:
  /hello:
    get:
      operationId: sayHello${firstHandlerLanguage
                ? `
      x-handler:
        language: ${firstHandlerLanguage}`
                : ""}
      parameters:
        - in: query
          name: name
          schema:
            type: string
          required: true
      responses:
        200:
          description: Successful response
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/SayHelloResponseContent'
        500:
          description: An internal failure at the fault of the server
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/InternalFailureErrorResponseContent'
        400:
          description: An error at the fault of the client sending invalid input
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/BadRequestErrorResponseContent'
        403:
          description: An error due to the client not being authorized to access the resource
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/NotAuthorizedErrorResponseContent'
components:
  schemas:
    SayHelloResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    InternalFailureErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    BadRequestErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    NotAuthorizedErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
`,
        });
    }
}
exports.OpenApiDefinition = OpenApiDefinition;
_a = JSII_RTTI_SYMBOL_1;
OpenApiDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiDefinition", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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