"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_definition_1 = require("./open-api-definition");
const type_safe_api_command_environment_1 = require("../../codegen/components/type-safe-api-command-environment");
const types_1 = require("../../types");
const model_readme_1 = require("../model-readme");
const type_safe_api_model_build_1 = require("../type-safe-api-model-build");
/**
 * Project for defining an OpenAPI model for a REST API
 */
class OpenApiModelProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.definition = new open_api_definition_1.OpenApiDefinition(this, options);
        this.apiName = options.openApiOptions.title;
        new type_safe_api_model_build_1.TypeSafeApiModelBuild(this, {
            openApiSpecificationPath: this.definition.openApiSpecificationPath,
            parsedSpecFile: options.parsedSpecFile,
        });
        new model_readme_1.ModelReadme(this, {
            modelLanguage: types_1.ModelLanguage.OPENAPI,
            apiType: "rest",
        });
    }
}
exports.OpenApiModelProject = OpenApiModelProject;
_a = JSII_RTTI_SYMBOL_1;
OpenApiModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiModelProject", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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