"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyAsyncModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const type_safe_api_command_environment_1 = require("../../codegen/components/type-safe-api-command-environment");
const types_1 = require("../../types");
const model_readme_1 = require("../model-readme");
const type_safe_api_async_model_build_1 = require("../type-safe-api-async-model-build");
const type_safe_api_model_build_1 = require("../type-safe-api-model-build");
const smithy_async_sample_code_1 = require("./components/smithy-async-sample-code");
const smithy_aws_pdk_async_prelude_1 = require("./components/smithy-aws-pdk-async-prelude");
const smithy_base_project_1 = require("./smithy-base-project");
const smithy_service_project_definition_1 = require("./smithy-service-project-definition");
const generate_task_1 = require("../../codegen/components/generate-task");
const utils_1 = require("../../codegen/components/utils");
/**
 * Smithy model project for a WebSocket API
 */
class SmithyAsyncModelProject extends smithy_base_project_1.SmithyBaseProject {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.definition = new smithy_service_project_definition_1.SmithyServiceProjectDefinition(this, {
            ...options,
            smithyOptions: {
                ...options.smithyOptions,
                smithyBuildOptions: {
                    ...options.smithyOptions.smithyBuildOptions,
                    projections: {
                        ...options.smithyOptions.smithyBuildOptions?.projections,
                        openapi: {
                            ...options.smithyOptions.smithyBuildOptions?.projections?.openapi,
                            transforms: [
                                // Add the async transform to the openapi projection
                                { name: "aws-pdk-async-transformer", args: {} },
                            ],
                        },
                    },
                },
            },
        });
        this.apiName = options.smithyOptions.serviceName.serviceName;
        const { namespace: serviceNamespace, serviceName } = options.smithyOptions.serviceName;
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create the default smithy model
        new smithy_async_sample_code_1.SmithyAsyncSampleCode(this, {
            modelDir: this.definition.modelDir,
            serviceName,
            serviceNamespace,
            firstHandlerLanguage,
        });
        // Add the additional async prelude
        new smithy_aws_pdk_async_prelude_1.SmithyAwsPdkAsyncPrelude(this, {
            generatedModelDir: this.definition.generatedModelDir,
            serviceNamespace,
            handlerLanguages: options.handlerLanguages,
        });
        const generateTask = generate_task_1.GenerateTask.ensure(this);
        // Copy the async transformer jar
        generateTask.prependExec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.COPY_ASYNC_SMITHY_TRANSFORMER));
        this.definition.addDeps(`file://.smithy-async/aws-pdk-smithy-async-transformer.jar`);
        this.gitignore.addPatterns(".smithy-async");
        new type_safe_api_model_build_1.TypeSafeApiModelBuild(this, {
            openApiSpecificationPath: this.definition.openApiSpecificationPath,
            smithyJsonModelPath: this.definition.smithyJsonModelPath,
            parsedSpecFile: options.parsedSpecFile,
        });
        new type_safe_api_async_model_build_1.TypeSafeApiAsyncModelBuild(this, {
            parsedSpecFile: options.parsedSpecFile,
            asyncApiSpecFile: options.asyncApiSpecFile,
        });
        new model_readme_1.ModelReadme(this, {
            modelLanguage: types_1.ModelLanguage.SMITHY,
            apiType: "async",
        });
    }
    smithyProjectDefinition() {
        return this.definition;
    }
}
exports.SmithyAsyncModelProject = SmithyAsyncModelProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyAsyncModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.SmithyAsyncModelProject", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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