"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const type_safe_api_command_environment_1 = require("../../codegen/components/type-safe-api-command-environment");
const types_1 = require("../../types");
const model_readme_1 = require("../model-readme");
const type_safe_api_model_build_1 = require("../type-safe-api-model-build");
const smithy_sample_code_1 = require("./components/smithy-sample-code");
const smithy_base_project_1 = require("./smithy-base-project");
const smithy_service_project_definition_1 = require("./smithy-service-project-definition");
/**
 * Smithy model project for a REST API
 */
class SmithyModelProject extends smithy_base_project_1.SmithyBaseProject {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.definition = new smithy_service_project_definition_1.SmithyServiceProjectDefinition(this, options);
        this.apiName = options.smithyOptions.serviceName.serviceName;
        const { namespace: serviceNamespace, serviceName } = options.smithyOptions.serviceName;
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create the default smithy model
        new smithy_sample_code_1.SmithySampleCode(this, {
            modelDir: this.definition.modelDir,
            serviceName,
            serviceNamespace,
            firstHandlerLanguage,
        });
        new type_safe_api_model_build_1.TypeSafeApiModelBuild(this, {
            openApiSpecificationPath: this.definition.openApiSpecificationPath,
            smithyJsonModelPath: this.definition.smithyJsonModelPath,
            parsedSpecFile: options.parsedSpecFile,
        });
        new model_readme_1.ModelReadme(this, {
            modelLanguage: types_1.ModelLanguage.SMITHY,
            apiType: "rest",
        });
    }
    smithyProjectDefinition() {
        return this.definition;
    }
}
exports.SmithyModelProject = SmithyModelProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.SmithyModelProject", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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