import { SmithyBaseProject, SmithyBaseProjectOptions } from "./smithy-base-project";
import { SmithyProjectDefinition, SmithyProjectDefinitionOptions } from "./smithy-project-definition";
/**
 * Options for the Smithy shape library
 */
export interface SmithyShapeLibraryProjectOptions extends SmithyBaseProjectOptions, SmithyProjectDefinitionOptions {
}
/**
 * A project for defining a library of Smithy shapes which can be consumed by other projects
 */
export declare class SmithyShapeLibraryProject extends SmithyBaseProject {
    /**
     * Smithy model and build settings
     */
    readonly definition: SmithyProjectDefinition;
    constructor(options: SmithyShapeLibraryProjectOptions);
    smithyProjectDefinition(): SmithyProjectDefinition;
}
