"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyShapeLibraryProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const smithy_shape_library_sample_code_1 = require("./components/smithy-shape-library-sample-code");
const smithy_base_project_1 = require("./smithy-base-project");
const smithy_project_definition_1 = require("./smithy-project-definition");
const generate_task_1 = require("../../codegen/components/generate-task");
const type_safe_api_command_environment_1 = require("../../codegen/components/type-safe-api-command-environment");
/**
 * A project for defining a library of Smithy shapes which can be consumed by other projects
 */
class SmithyShapeLibraryProject extends smithy_base_project_1.SmithyBaseProject {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.definition = new smithy_project_definition_1.SmithyProjectDefinition(this, options);
        this.compileTask.spawn(generate_task_1.GenerateTask.ensure(this));
        new smithy_shape_library_sample_code_1.SmithyShapeLibrarySampleCode(this, {
            modelDir: this.definition.modelDir,
            // Namespace here is just rendered into sample code and user is free to edit
            namespace: "com.example",
        });
    }
    smithyProjectDefinition() {
        return this.definition;
    }
}
exports.SmithyShapeLibraryProject = SmithyShapeLibraryProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyShapeLibraryProject[_a] = { fqn: "@aws/pdk.type_safe_api.SmithyShapeLibraryProject", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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