"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiAsyncModelBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const generate_task_1 = require("../codegen/components/generate-task");
const utils_1 = require("../codegen/components/utils");
/**
 * Adds a task to convert the OpenAPI specification into an AsyncAPI specification,
 * which can be used for documentation generation.
 */
class TypeSafeApiAsyncModelBuild extends projen_1.Component {
    constructor(project, options) {
        super(project);
        const { parsedSpecFile, asyncApiSpecFile } = options;
        const generateTask = generate_task_1.GenerateTask.ensure(project);
        generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_ASYNCAPI_SPEC, `--specPath ${parsedSpecFile} --outputPath ${asyncApiSpecFile}`));
        project.addGitIgnore(asyncApiSpecFile);
    }
}
exports.TypeSafeApiAsyncModelBuild = TypeSafeApiAsyncModelBuild;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiAsyncModelBuild[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiAsyncModelBuild", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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