"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiModelBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const generate_task_1 = require("../codegen/components/generate-task");
const utils_1 = require("../codegen/components/utils");
/**
 * Adds the build task for parsing/bundling an OpenAPI spec ready for use by code generation projects
 */
class TypeSafeApiModelBuild extends projen_1.Component {
    constructor(project, options) {
        super(project);
        const { openApiSpecificationPath, smithyJsonModelPath, parsedSpecFile } = options;
        const generateTask = generate_task_1.GenerateTask.ensure(project);
        generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.PARSE_OPENAPI_SPEC, `--specPath ${openApiSpecificationPath} --outputPath ${parsedSpecFile}${smithyJsonModelPath ? ` --smithyJsonPath ${smithyJsonModelPath}` : ""}`));
        project.compileTask.spawn(generateTask);
        project.addGitIgnore(parsedSpecFile);
    }
}
exports.TypeSafeApiModelBuild = TypeSafeApiModelBuild;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiModelBuild[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiModelBuild", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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