"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSpecAwsPdkPreludeJs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
/**
 * Synthesize the aws-pdk/prelude.js file
 */
class TypeSpecAwsPdkPreludeJs extends projen_1.FileBase {
    constructor(project, options) {
        super(project, path.join(options.generatedModelDir, "aws-pdk", "prelude.js"), {
            marker: true,
            readonly: true,
        });
    }
    synthesizeContent(_) {
        // Define the implementation for the @handler decorator. This reuses the @extension decorator
        // for adding an OpenAPI extension, but abstracts the `x-handler` key.
        return `// ${this.marker}
import { $extension } from "@typespec/openapi";

export function $handler(context, target, value) {
  $extension(context, target, "x-handler", value);
}
`;
    }
}
exports.TypeSpecAwsPdkPreludeJs = TypeSpecAwsPdkPreludeJs;
//# sourceMappingURL=data:application/json;base64,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