import { Project, FileBase, IResolver } from "projen";
import { Language } from "../../../languages";
/**
 * Options for the aws-pdk/prelude.tsp file
 */
export interface TypeSpecAwsPdkPreludeOptions {
    /**
     * Path to the generated model directory in which to add the prelude
     */
    readonly generatedModelDir: string;
    /**
     * Languages selected for handlers
     */
    readonly handlerLanguages?: Language[];
}
/**
 * Synthesize the aws-pdk/prelude.tsp file
 */
export declare class TypeSpecAwsPdkPrelude extends FileBase {
    private readonly options;
    constructor(project: Project, options: TypeSpecAwsPdkPreludeOptions);
    synthesizeContent(_: IResolver): string | undefined;
}
