/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, SampleDir } from "projen";
import { TypeSpecDefinitionOptions } from "../type-spec-definition";
/**
 * Options for TypeSpec sample code
 */
export interface TypeSpecSampleCodeOptions extends TypeSpecDefinitionOptions {
    /**
     * Location for the TypeSpec model
     */
    readonly modelDir: string;
}
/**
 * Defines sample code for a TypeSpec REST API
 */
export declare class TypeSpecSampleCode extends SampleDir {
    constructor(project: Project, { modelDir, typeSpecOptions, handlerLanguages }: TypeSpecSampleCodeOptions);
}
