"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSpecSampleCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Defines sample code for a TypeSpec REST API
 */
class TypeSpecSampleCode extends projen_1.SampleDir {
    constructor(project, { modelDir, typeSpecOptions, handlerLanguages }) {
        const firstHandlerLanguage = handlerLanguages?.[0];
        super(project, modelDir, {
            files: {
                "main.tsp": `import "@typespec/http";
import "@typespec/openapi";
import "@typespec/openapi3";
import "../generated/aws-pdk/prelude.tsp";

import "./types/errors.tsp";

using Http;
using OpenAPI;

/**
 * A sample TypeSpec api
 */
@service({
  title: "${typeSpecOptions.namespace}",
})
@info({
  version: "1.0",
})
namespace ${typeSpecOptions.namespace};

${firstHandlerLanguage
                    ? `@handler({ language: "${firstHandlerLanguage}" })
`
                    : ""}@get
@route("/hello")
op SayHello(@query name: string):
  | {
    @statusCode statusCode: 200;
    @body body: {
      message: string;
    };
  }
  | BadRequestError
  | NotAuthorizedError
  | NotFoundError
  | InternalFailureError;
`,
                "types/errors.tsp": `import "@typespec/http";

using Http;

/**
 * An error at the fault of the client sending invalid input
 */
model BadRequestErrorResponseContent {
  /**
   * Message with details about the error
   */
  message: string;
}

/**
 * An internal failure at the fault of the server
 */
model InternalFailureErrorResponseContent {
  /**
   * Message with details about the error
   */
  message: string;
}

/**
 * An error due to the client not being authorized to access the resource
 */
model NotAuthorizedErrorResponseContent {
  /**
   * Message with details about the error
   */
  message: string;
}

/**
 * An error due to the client attempting to access a missing resource
 */
model NotFoundErrorResponseContent {
  /**
   * Message with details about the error
   */
  message: string;
}

/**
 * BadRequestError 400 response
 */
@error
model BadRequestError {
  @statusCode statusCode: 400;
  @body body: BadRequestErrorResponseContent;
}

/**
 * NotAuthorizedError 403 response
 */
@error
model NotAuthorizedError {
  @statusCode statusCode: 403;
  @body body: NotAuthorizedErrorResponseContent;
}

/**
 * NotFoundError 404 response
 */
@error
model NotFoundError {
  @statusCode statusCode: 404;
  @body body: NotFoundErrorResponseContent;
}

/**
 * InternalFailureError 500 response
 */
@error
model InternalFailureError {
  @statusCode statusCode: 500;
  @body body: InternalFailureErrorResponseContent;
}
`,
            },
        });
    }
}
exports.TypeSpecSampleCode = TypeSpecSampleCode;
//# sourceMappingURL=data:application/json;base64,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