"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSpecAsyncDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_spec_async_aws_pdk_prelude_1 = require("./components/type-spec-async-aws-pdk-prelude");
const type_spec_async_aws_pdk_prelude_js_1 = require("./components/type-spec-async-aws-pdk-prelude-js");
const type_spec_async_sample_code_1 = require("./components/type-spec-async-sample-code");
const type_spec_project_definition_1 = require("./type-spec-project-definition");
/**
 * The TypeSpec model definition for an async api
 */
class TypeSpecAsyncDefinition extends type_spec_project_definition_1.TypeSpecProjectDefinition {
    constructor(project, options) {
        super(project, options);
        // Add the async prelude files which define the @async, @connectHandler and @disconnectHandler decorators
        new type_spec_async_aws_pdk_prelude_1.TypeSpecAsyncAwsPdkPrelude(project, {
            generatedModelDir: this.generatedModelDir,
        });
        new type_spec_async_aws_pdk_prelude_js_1.TypeSpecAsyncAwsPdkPreludeJs(project, {
            generatedModelDir: this.generatedModelDir,
        });
        // Add the sample code for TypeSpec websocket APIs
        new type_spec_async_sample_code_1.TypeSpecAsyncSampleCode(project, {
            ...options,
            modelDir: this.modelDir,
        });
    }
}
exports.TypeSpecAsyncDefinition = TypeSpecAsyncDefinition;
_a = JSII_RTTI_SYMBOL_1;
TypeSpecAsyncDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSpecAsyncDefinition", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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