"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSpecProjectDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const type_spec_aws_pdk_prelude_1 = require("./components/type-spec-aws-pdk-prelude");
const type_spec_aws_pdk_prelude_js_1 = require("./components/type-spec-aws-pdk-prelude-js");
const generate_task_1 = require("../../codegen/components/generate-task");
/**
 * Creates a project which allows APIs to be defined in TypeSpec
 * @see https://typespec.io/
 */
class TypeSpecProjectDefinition extends projen_1.Component {
    constructor(project, options) {
        super(project);
        /**
         * Directory in which the model source resides
         */
        this.modelDir = "src";
        /**
         * Directory in which generated model source resides
         */
        this.generatedModelDir = "generated";
        const { handlerLanguages } = options;
        // Add dependencies on the TypeSpec compiler and http/openapi libraries
        project.addDevDeps("@typespec/compiler@^0.61", "@typespec/http@^0.61", "@typespec/openapi@^0.61", "@typespec/openapi3@^0.61");
        const outputDir = "dist";
        const outputFile = "openapi.json";
        project.gitignore.addPatterns(outputDir);
        // Compiled output is located under a directory for the emitter we're using, in this case @typespec/openapi3
        this.openApiSpecificationPath = path.join(outputDir, "@typespec", "openapi3", outputFile);
        // Configuration for the typespec compiler
        new projen_1.YamlFile(this, "tspconfig.yaml", {
            obj: {
                emit: ["@typespec/openapi3"],
                options: {
                    "@typespec/openapi3": {
                        "output-file": outputFile,
                    },
                },
                "output-dir": path.join("{cwd}", outputDir),
            },
        });
        // Add the prelude which defines our custom @handler decorator
        new type_spec_aws_pdk_prelude_1.TypeSpecAwsPdkPrelude(project, {
            generatedModelDir: this.generatedModelDir,
            handlerLanguages,
        });
        new type_spec_aws_pdk_prelude_js_1.TypeSpecAwsPdkPreludeJs(project, {
            generatedModelDir: this.generatedModelDir,
        });
        const generateTask = generate_task_1.GenerateTask.ensure(project);
        // In order for typespec to load our prelude javascript file(s), we need to ensure
        // it's treated as a module
        generateTask.env("NODE_OPTIONS", "--experimental-default-type=module");
        // Compile typespec to openapi
        generateTask.exec(`tsp compile ${this.modelDir} --config tspconfig.yaml`);
    }
}
exports.TypeSpecProjectDefinition = TypeSpecProjectDefinition;
_a = JSII_RTTI_SYMBOL_1;
TypeSpecProjectDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSpecProjectDefinition", version: "0.25.8" };
//# sourceMappingURL=data:application/json;base64,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