"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = exports.ModelLanguage = void 0;
/**
 * The model definition language
 */
var ModelLanguage;
(function (ModelLanguage) {
    /**
     * Smithy
     * @see https://smithy.io/2.0/
     */
    ModelLanguage["SMITHY"] = "SMITHY";
    /**
     * OpenAPI
     * @see https://www.openapis.org/
     */
    ModelLanguage["OPENAPI"] = "OPENAPI";
    /**
     * TypeSpec
     * @see https://typespec.io/
     */
    ModelLanguage["TYPESPEC"] = "TYPESPEC";
})(ModelLanguage || (exports.ModelLanguage = ModelLanguage = {}));
/**
 * Represents an instruction set architecture
 */
var Architecture;
(function (Architecture) {
    /**
     * 64-bit x86 architecture
     */
    Architecture["X86_64"] = "X86_64";
    /**
     * 64-bit ARM architecture
     */
    Architecture["ARM_64"] = "ARM_64";
})(Architecture || (exports.Architecture = Architecture = {}));
//# sourceMappingURL=data:application/json;base64,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