// SPDX-License-Identifier: UNLICENSED
pragma solidity ^0.8.13;

import "forge-std/Test.sol";
import "../src/VulnerableToken.sol";

contract VulnerableTokenTest is Test {
    VulnerableToken public token;

    function setUp() public {
        token = new VulnerableToken();
    }

    function testTransfer(address _to, uint96 _value) public {
        uint256 balancePrior = token.balanceOf(address(0x7FA9385bE102ac3EAc297483Dd6233D62b3e1496));
        token.transfer(_to, _value);
        assertEq(token.balanceOf(_to), _value);
        assertEq(token.balanceOf(address(0x7FA9385bE102ac3EAc297483Dd6233D62b3e1496)), balancePrior - _value);
    }
}
