// This file is @generated by prost-build.
/// <https://en.wikipedia.org/wiki/Unit_type>
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Unit {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Schema {
    #[prost(message, repeated, tag = "1")]
    pub fields: ::prost::alloc::vec::Vec<Field>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DataType {
    #[prost(
        oneof = "data_type::Variant",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35"
    )]
    pub variant: ::core::option::Option<data_type::Variant>,
}
/// Nested message and enum types in `DataType`.
pub mod data_type {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Decimal128 {
        #[prost(uint64, tag = "1")]
        pub precision: u64,
        #[prost(uint64, tag = "2")]
        pub scale: u64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Timestamp {
        #[prost(enumeration = "super::TimeUnit", tag = "1")]
        pub unit: i32,
        #[prost(string, optional, tag = "2")]
        pub timezone: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Time {
        #[prost(enumeration = "super::TimeUnit", tag = "1")]
        pub unit: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Duration {
        #[prost(enumeration = "super::TimeUnit", tag = "1")]
        pub unit: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct FixedSizeBinary {
        #[prost(uint64, tag = "1")]
        pub size: u64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FixedSizeList {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(uint64, tag = "2")]
        pub size: u64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct List {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Struct {
        #[prost(message, repeated, tag = "1")]
        pub fields: ::prost::alloc::vec::Vec<super::Field>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Map {
        #[prost(message, optional, boxed, tag = "1")]
        pub key_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(message, optional, boxed, tag = "2")]
        pub value_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Extension {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, optional, boxed, tag = "2")]
        pub data_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(string, optional, tag = "3")]
        pub metadata: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Embedding {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(uint64, tag = "2")]
        pub size: u64,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Image {
        #[prost(enumeration = "super::ImageMode", optional, tag = "1")]
        pub mode: ::core::option::Option<i32>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct FixedShapeImage {
        #[prost(enumeration = "super::ImageMode", tag = "1")]
        pub mode: i32,
        #[prost(uint32, tag = "2")]
        pub height: u32,
        #[prost(uint32, tag = "3")]
        pub width: u32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Tensor {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FixedShapeTensor {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(uint64, repeated, tag = "2")]
        pub shape: ::prost::alloc::vec::Vec<u64>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SparseTensor {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(bool, tag = "2")]
        pub indices_offset: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FixedShapeSparseTensor {
        #[prost(message, optional, boxed, tag = "1")]
        pub element_type: ::core::option::Option<::prost::alloc::boxed::Box<super::DataType>>,
        #[prost(uint64, repeated, tag = "2")]
        pub shape: ::prost::alloc::vec::Vec<u64>,
        #[prost(bool, tag = "3")]
        pub indices_offset: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Null(super::Unit),
        #[prost(message, tag = "2")]
        Boolean(super::Unit),
        #[prost(message, tag = "3")]
        Int8(super::Unit),
        #[prost(message, tag = "4")]
        Int16(super::Unit),
        #[prost(message, tag = "5")]
        Int32(super::Unit),
        #[prost(message, tag = "6")]
        Int64(super::Unit),
        #[prost(message, tag = "7")]
        Uint8(super::Unit),
        #[prost(message, tag = "8")]
        Uint16(super::Unit),
        #[prost(message, tag = "9")]
        Uint32(super::Unit),
        #[prost(message, tag = "10")]
        Uint64(super::Unit),
        #[prost(message, tag = "11")]
        Float32(super::Unit),
        #[prost(message, tag = "12")]
        Float64(super::Unit),
        #[prost(message, tag = "13")]
        Decimal128(Decimal128),
        #[prost(message, tag = "14")]
        Timestamp(Timestamp),
        #[prost(message, tag = "15")]
        Date(super::Unit),
        #[prost(message, tag = "16")]
        Time(Time),
        #[prost(message, tag = "17")]
        Duration(Duration),
        #[prost(message, tag = "18")]
        Interval(super::Unit),
        #[prost(message, tag = "19")]
        Binary(super::Unit),
        #[prost(message, tag = "20")]
        FixedSizeBinary(FixedSizeBinary),
        #[prost(message, tag = "21")]
        Utf8(super::Unit),
        #[prost(message, tag = "22")]
        FixedSizeList(::prost::alloc::boxed::Box<FixedSizeList>),
        #[prost(message, tag = "23")]
        List(::prost::alloc::boxed::Box<List>),
        #[prost(message, tag = "24")]
        Struct(Struct),
        #[prost(message, tag = "25")]
        Map(::prost::alloc::boxed::Box<Map>),
        #[prost(message, tag = "26")]
        Extension(::prost::alloc::boxed::Box<Extension>),
        #[prost(message, tag = "27")]
        Embedding(::prost::alloc::boxed::Box<Embedding>),
        #[prost(message, tag = "28")]
        Image(Image),
        #[prost(message, tag = "29")]
        FixedShapeImage(FixedShapeImage),
        #[prost(message, tag = "30")]
        Tensor(::prost::alloc::boxed::Box<Tensor>),
        #[prost(message, tag = "31")]
        FixedShapeTensor(::prost::alloc::boxed::Box<FixedShapeTensor>),
        #[prost(message, tag = "32")]
        SparseTensor(::prost::alloc::boxed::Box<SparseTensor>),
        #[prost(message, tag = "33")]
        FixedShapeSparseTensor(::prost::alloc::boxed::Box<FixedShapeSparseTensor>),
        #[prost(message, tag = "34")]
        Python(super::Unit),
        #[prost(message, tag = "35")]
        Unknown(super::Unit),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Field {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub data_type: ::core::option::Option<DataType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Expr {
    #[prost(
        oneof = "expr::Variant",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21"
    )]
    pub variant: ::core::option::Option<expr::Variant>,
}
/// Nested message and enum types in `Expr`.
pub mod expr {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Column(super::Column),
        #[prost(message, tag = "2")]
        Alias(::prost::alloc::boxed::Box<super::Alias>),
        #[prost(message, tag = "3")]
        Agg(::prost::alloc::boxed::Box<super::Agg>),
        #[prost(message, tag = "4")]
        BinaryOp(::prost::alloc::boxed::Box<super::BinaryOp>),
        #[prost(message, tag = "5")]
        Cast(::prost::alloc::boxed::Box<super::Cast>),
        #[prost(message, tag = "6")]
        Function(super::Function),
        #[prost(message, tag = "7")]
        Over(::prost::alloc::boxed::Box<super::Over>),
        #[prost(message, tag = "8")]
        WindowFunction(::prost::alloc::boxed::Box<super::WindowFunction>),
        #[prost(message, tag = "9")]
        Not(::prost::alloc::boxed::Box<super::Not>),
        #[prost(message, tag = "10")]
        IsNull(::prost::alloc::boxed::Box<super::IsNull>),
        #[prost(message, tag = "11")]
        NotNull(::prost::alloc::boxed::Box<super::NotNull>),
        #[prost(message, tag = "12")]
        FillNull(::prost::alloc::boxed::Box<super::FillNull>),
        #[prost(message, tag = "13")]
        IsIn(::prost::alloc::boxed::Box<super::IsIn>),
        #[prost(message, tag = "14")]
        Between(::prost::alloc::boxed::Box<super::Between>),
        #[prost(message, tag = "15")]
        List(super::List),
        #[prost(message, tag = "16")]
        Literal(super::Literal),
        #[prost(message, tag = "17")]
        IfElse(::prost::alloc::boxed::Box<super::IfElse>),
        #[prost(message, tag = "18")]
        Subquery(::prost::alloc::boxed::Box<super::Subquery>),
        #[prost(message, tag = "19")]
        SubqueryComp(::prost::alloc::boxed::Box<super::SubqueryComp>),
        #[prost(message, tag = "20")]
        SubqueryIn(::prost::alloc::boxed::Box<super::SubqueryIn>),
        #[prost(message, tag = "21")]
        SubqueryTest(::prost::alloc::boxed::Box<super::SubqueryTest>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Literal {
    #[prost(
        oneof = "literal::Variant",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21"
    )]
    pub variant: ::core::option::Option<literal::Variant>,
}
/// Nested message and enum types in `Literal`.
pub mod literal {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FixedSizeBinary {
        #[prost(bytes = "vec", tag = "1")]
        pub value: ::prost::alloc::vec::Vec<u8>,
        #[prost(uint64, tag = "2")]
        pub size: u64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Timestamp {
        #[prost(int64, tag = "1")]
        pub value: i64,
        #[prost(enumeration = "super::TimeUnit", tag = "2")]
        pub unit: i32,
        #[prost(string, optional, tag = "3")]
        pub timezone: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Time {
        #[prost(int64, tag = "1")]
        pub value: i64,
        #[prost(enumeration = "super::TimeUnit", tag = "2")]
        pub unit: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Duration {
        #[prost(int64, tag = "1")]
        pub value: i64,
        #[prost(enumeration = "super::TimeUnit", tag = "2")]
        pub unit: i32,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Interval {
        #[prost(int32, tag = "1")]
        pub months: i32,
        #[prost(int32, tag = "2")]
        pub days: i32,
        #[prost(int64, tag = "3")]
        pub nanoseconds: i64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Decimal {
        #[prost(string, tag = "1")]
        pub value: ::prost::alloc::string::String,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Struct {
        #[prost(message, repeated, tag = "1")]
        pub fields: ::prost::alloc::vec::Vec<r#struct::Field>,
    }
    /// Nested message and enum types in `Struct`.
    pub mod r#struct {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Field {
            #[prost(string, tag = "1")]
            pub name: ::prost::alloc::string::String,
            #[prost(message, optional, tag = "2")]
            pub value: ::core::option::Option<super::super::Literal>,
        }
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Null(super::Unit),
        #[prost(bool, tag = "2")]
        Boolean(bool),
        #[prost(string, tag = "3")]
        Utf8(::prost::alloc::string::String),
        #[prost(bytes, tag = "4")]
        Binary(::prost::alloc::vec::Vec<u8>),
        #[prost(message, tag = "5")]
        FixedSizeBinary(FixedSizeBinary),
        #[prost(int32, tag = "6")]
        Int8(i32),
        #[prost(uint32, tag = "7")]
        Uint8(u32),
        #[prost(int32, tag = "8")]
        Int16(i32),
        #[prost(uint32, tag = "9")]
        Uint16(u32),
        #[prost(int32, tag = "10")]
        Int32(i32),
        #[prost(uint32, tag = "11")]
        Uint32(u32),
        #[prost(int64, tag = "12")]
        Int64(i64),
        #[prost(uint64, tag = "13")]
        Uint64(u64),
        #[prost(message, tag = "14")]
        Timestamp(Timestamp),
        #[prost(int32, tag = "15")]
        Date(i32),
        #[prost(message, tag = "16")]
        Time(Time),
        #[prost(message, tag = "17")]
        Duration(Duration),
        #[prost(message, tag = "18")]
        Interval(Interval),
        #[prost(double, tag = "19")]
        Float64(f64),
        #[prost(message, tag = "20")]
        Decimal(Decimal),
        #[prost(message, tag = "21")]
        Struct(Struct),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Column {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint64, optional, tag = "2")]
    pub qualifier: ::core::option::Option<u64>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Alias {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(string, tag = "2")]
    pub name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BinaryOp {
    #[prost(enumeration = "Operator", tag = "1")]
    pub op: i32,
    #[prost(message, optional, boxed, tag = "2")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Cast {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, tag = "2")]
    pub dtype: ::core::option::Option<DataType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Not {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NotNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FillNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub fill_value: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsIn {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, repeated, tag = "2")]
    pub items: ::prost::alloc::vec::Vec<Expr>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Between {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub lower: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub upper: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct List {
    #[prost(message, repeated, tag = "1")]
    pub items: ::prost::alloc::vec::Vec<Expr>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IfElse {
    #[prost(message, optional, boxed, tag = "1")]
    pub if_true: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub if_false: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub predicate: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Function {
    #[prost(message, optional, tag = "3")]
    pub args: ::core::option::Option<function::Args>,
    #[prost(oneof = "function::Descriptor", tags = "1, 2")]
    pub descriptor: ::core::option::Option<function::Descriptor>,
}
/// Nested message and enum types in `Function`.
pub mod function {
    /// For rust functions (builtins), we only have simple names.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct RsFunction {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
    }
    /// TODO: Daft does not handle static parameter binding.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Args {
        #[prost(message, repeated, tag = "1")]
        pub args: ::prost::alloc::vec::Vec<Arg>,
    }
    /// TODO: Update param to required after static parameter binding is implemented.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Arg {
        #[prost(string, optional, tag = "1")]
        pub param: ::core::option::Option<::prost::alloc::string::String>,
        #[prost(message, optional, tag = "2")]
        pub expr: ::core::option::Option<super::Expr>,
    }
    /// For python functions (UDF), we need the pickled object and bound args.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct PyFunction {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(uint64, tag = "2")]
        pub arity: u64,
        #[prost(message, optional, tag = "3")]
        pub return_type: ::core::option::Option<super::DataType>,
        /// --
        #[prost(message, optional, tag = "4")]
        pub callable: ::core::option::Option<super::PyObject>,
        /// the __init__ args for runtime initialization
        #[prost(message, optional, tag = "5")]
        pub callable_init_args: ::core::option::Option<super::PyObject>,
        /// the (possibly) closed args from decoration
        #[prost(message, optional, tag = "6")]
        pub callable_call_args: ::core::option::Option<super::PyObject>,
        /// --
        #[prost(uint64, optional, tag = "7")]
        pub concurrency: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "8")]
        pub batch_size: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "9")]
        pub num_cpus: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "10")]
        pub num_gpus: ::core::option::Option<u64>,
        #[prost(uint64, optional, tag = "11")]
        pub max_memory_bytes: ::core::option::Option<u64>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Descriptor {
        #[prost(message, tag = "1")]
        Rs(RsFunction),
        #[prost(message, tag = "2")]
        Py(PyFunction),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Over {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<WindowExpr>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub spec: ::core::option::Option<::prost::alloc::boxed::Box<WindowSpec>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowFunction {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<WindowExpr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowExpr {
    #[prost(oneof = "window_expr::Variant", tags = "1, 2, 3, 4, 5")]
    pub variant: ::core::option::Option<window_expr::Variant>,
}
/// Nested message and enum types in `WindowExpr`.
pub mod window_expr {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Agg(::prost::alloc::boxed::Box<super::Agg>),
        #[prost(bool, tag = "2")]
        RowNumber(bool),
        #[prost(bool, tag = "3")]
        Rank(bool),
        #[prost(bool, tag = "4")]
        DenseRank(bool),
        #[prost(message, tag = "5")]
        Offset(::prost::alloc::boxed::Box<super::Offset>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Offset {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(int32, tag = "2")]
    pub offset: i32,
    #[prost(message, optional, boxed, tag = "3")]
    pub default: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowSpec {
    #[prost(message, repeated, tag = "1")]
    pub partition_by: ::prost::alloc::vec::Vec<Expr>,
    #[prost(message, repeated, tag = "2")]
    pub order_by: ::prost::alloc::vec::Vec<SortOrder>,
    #[prost(message, optional, boxed, tag = "3")]
    pub frame: ::core::option::Option<::prost::alloc::boxed::Box<WindowFrame>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortOrder {
    #[prost(message, optional, tag = "1")]
    pub expr: ::core::option::Option<Expr>,
    #[prost(bool, tag = "2")]
    pub ascending: bool,
    #[prost(bool, tag = "3")]
    pub nulls_first: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowFrame {
    #[prost(enumeration = "FrameType", tag = "1")]
    pub r#type: i32,
    #[prost(message, optional, boxed, tag = "2")]
    pub start: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub end: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
/// Daft currently only has scalar subquery coercion so just an input is fine for now.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Subquery {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
/// See SQL `<comparison predicate>` and `<quantified comparison predicate>`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SubqueryComp {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub args: ::prost::alloc::vec::Vec<Expr>,
    #[prost(enumeration = "Comparison", tag = "3")]
    pub comparison: i32,
    #[prost(enumeration = "Quantifier", tag = "4")]
    pub quantifier: i32,
}
/// See SQL `<in predicate>`
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SubqueryIn {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub args: ::prost::alloc::vec::Vec<Expr>,
}
/// See SQL `<exists predicate>` and `<unique predicate>`.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SubqueryTest {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(enumeration = "subquery_test::Test", tag = "2")]
    pub test: i32,
}
/// Nested message and enum types in `SubqueryTest`.
pub mod subquery_test {
    /// EXISTS and UNIQUE are defined by SQL.
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Test {
        Unspecified = 0,
        Exists = 1,
        Unique = 2,
    }
    impl Test {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "TEST_UNSPECIFIED",
                Self::Exists => "TEST_EXISTS",
                Self::Unique => "TEST_UNIQUE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TEST_UNSPECIFIED" => Some(Self::Unspecified),
                "TEST_EXISTS" => Some(Self::Exists),
                "TEST_UNIQUE" => Some(Self::Unique),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Rel {
    #[prost(
        oneof = "rel::Variant",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23"
    )]
    pub variant: ::core::option::Option<rel::Variant>,
}
/// Nested message and enum types in `Rel`.
pub mod rel {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Aggregate(::prost::alloc::boxed::Box<super::RelAggregate>),
        #[prost(message, tag = "2")]
        Concat(::prost::alloc::boxed::Box<super::RelConcat>),
        #[prost(message, tag = "3")]
        Distinct(::prost::alloc::boxed::Box<super::RelDistinct>),
        #[prost(message, tag = "4")]
        Except(::prost::alloc::boxed::Box<super::RelExcept>),
        #[prost(message, tag = "5")]
        Filter(::prost::alloc::boxed::Box<super::RelFilter>),
        #[prost(message, tag = "6")]
        Intersect(::prost::alloc::boxed::Box<super::RelIntersect>),
        #[prost(message, tag = "7")]
        Join(::prost::alloc::boxed::Box<super::RelJoin>),
        #[prost(message, tag = "8")]
        Limit(::prost::alloc::boxed::Box<super::RelLimit>),
        #[prost(message, tag = "9")]
        Project(::prost::alloc::boxed::Box<super::RelProject>),
        #[prost(message, tag = "10")]
        Sink(::prost::alloc::boxed::Box<super::RelSink>),
        #[prost(message, tag = "11")]
        Sort(::prost::alloc::boxed::Box<super::RelSort>),
        #[prost(message, tag = "12")]
        Source(::prost::alloc::boxed::Box<super::RelSource>),
        #[prost(message, tag = "13")]
        Union(::prost::alloc::boxed::Box<super::RelUnion>),
        #[prost(message, tag = "14")]
        Window(::prost::alloc::boxed::Box<super::RelWindow>),
        /// --
        #[prost(message, tag = "15")]
        ActorPoolProject(::prost::alloc::boxed::Box<super::RelActorPoolProject>),
        #[prost(message, tag = "16")]
        Explode(::prost::alloc::boxed::Box<super::RelExplode>),
        #[prost(message, tag = "17")]
        MonotonicallyIncreasingId(::prost::alloc::boxed::Box<super::RelMonotonicallyIncreasingId>),
        #[prost(message, tag = "18")]
        Pivot(::prost::alloc::boxed::Box<super::RelPivot>),
        #[prost(message, tag = "19")]
        Repartition(::prost::alloc::boxed::Box<super::RelRepartition>),
        #[prost(message, tag = "20")]
        Sample(::prost::alloc::boxed::Box<super::RelSample>),
        #[prost(message, tag = "21")]
        SubqueryAlias(::prost::alloc::boxed::Box<super::RelSubqueryAlias>),
        #[prost(message, tag = "22")]
        TopN(::prost::alloc::boxed::Box<super::RelTopN>),
        #[prost(message, tag = "23")]
        Unpivot(::prost::alloc::boxed::Box<super::RelUnpivot>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelSource {
    #[prost(message, optional, tag = "1")]
    pub schema: ::core::option::Option<Schema>,
    #[prost(message, optional, boxed, tag = "2")]
    pub info: ::core::option::Option<::prost::alloc::boxed::Box<SourceInfo>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelProject {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub projections: ::prost::alloc::vec::Vec<Expr>,
}
/// This does not need to be separate, but it reduces impedance mismatch across the type definitions.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelActorPoolProject {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub projections: ::prost::alloc::vec::Vec<Expr>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelFilter {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub predicate: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelLimit {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(uint64, tag = "2")]
    pub limit: u64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelExplode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub projections: ::prost::alloc::vec::Vec<Expr>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelUnpivot {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelSort {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelRepartition {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelDistinct {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelAggregate {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, repeated, tag = "2")]
    pub measures: ::prost::alloc::vec::Vec<Measure>,
    #[prost(message, repeated, tag = "3")]
    pub groups: ::prost::alloc::vec::Vec<Expr>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelPivot {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelConcat {
    #[prost(message, optional, boxed, tag = "1")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelUnion {
    #[prost(message, optional, boxed, tag = "1")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(bool, tag = "3")]
    pub is_all: bool,
    #[prost(bool, tag = "4")]
    pub is_by_name: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelIntersect {
    #[prost(message, optional, boxed, tag = "1")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(bool, tag = "3")]
    pub is_all: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelExcept {
    #[prost(message, optional, boxed, tag = "1")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(bool, tag = "3")]
    pub is_all: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelJoin {
    #[prost(message, optional, boxed, tag = "1")]
    pub lhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub rhs: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelSink {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelSample {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelMonotonicallyIncreasingId {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelSubqueryAlias {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelWindow {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RelTopN {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<Rel>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SourceInfo {
    #[prost(oneof = "source_info::Variant", tags = "1, 2")]
    pub variant: ::core::option::Option<source_info::Variant>,
}
/// Nested message and enum types in `SourceInfo`.
pub mod source_info {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct CacheInfo {
        #[prost(message, optional, tag = "1")]
        pub schema: ::core::option::Option<super::Schema>,
        #[prost(string, tag = "2")]
        pub cache_key: ::prost::alloc::string::String,
        /// cache entry metadata
        #[prost(uint64, tag = "3")]
        pub num_partitions: u64,
        #[prost(uint64, tag = "4")]
        pub num_rows: u64,
        #[prost(uint64, tag = "5")]
        pub size_bytes: u64,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ScanInfo {
        #[prost(message, optional, tag = "1")]
        pub schema: ::core::option::Option<super::Schema>,
        #[prost(message, optional, tag = "2")]
        pub partitions: ::core::option::Option<super::PartitionFields>,
        #[prost(message, optional, boxed, tag = "3")]
        pub pushdowns: ::core::option::Option<::prost::alloc::boxed::Box<super::Pushdowns>>,
        #[prost(message, optional, tag = "4")]
        pub tasks: ::core::option::Option<super::ScanTasks>,
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        CacheInfo(CacheInfo),
        #[prost(message, tag = "2")]
        ScanInfo(::prost::alloc::boxed::Box<ScanInfo>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartitionFields {
    #[prost(message, repeated, tag = "1")]
    pub partitions: ::prost::alloc::vec::Vec<PartitionField>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartitionField {
    #[prost(message, optional, tag = "1")]
    pub field: ::core::option::Option<Field>,
    #[prost(message, optional, tag = "2")]
    pub source: ::core::option::Option<Field>,
    #[prost(message, optional, tag = "3")]
    pub transform: ::core::option::Option<PartitionTransform>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct PartitionTransform {
    #[prost(
        oneof = "partition_transform::Variant",
        tags = "1, 2, 4, 5, 6, 7, 8, 9"
    )]
    pub variant: ::core::option::Option<partition_transform::Variant>,
}
/// Nested message and enum types in `PartitionTransform`.
pub mod partition_transform {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct IcebergBucket {
        #[prost(uint64, tag = "1")]
        pub buckets: u64,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct IcebergTruncate {
        #[prost(uint64, tag = "2")]
        pub width: u64,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        Identity(super::Unit),
        #[prost(message, tag = "2")]
        Year(super::Unit),
        #[prost(message, tag = "4")]
        Month(super::Unit),
        #[prost(message, tag = "5")]
        Day(super::Unit),
        #[prost(message, tag = "6")]
        Hour(super::Unit),
        #[prost(message, tag = "7")]
        Void(super::Unit),
        #[prost(message, tag = "8")]
        IcebergBucket(IcebergBucket),
        #[prost(message, tag = "9")]
        IcebergTruncate(IcebergTruncate),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Pushdowns {
    /// This modeling inherently limits the ability to express composite predicates, and Clark acknowledge this limitation during implementation.
    /// see: TODO(Clark): Support pushing predicates referencing both partition and data columns into the scan.
    #[prost(message, optional, boxed, tag = "1")]
    pub filter: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub partition_filter: ::core::option::Option<::prost::alloc::boxed::Box<Expr>>,
    #[prost(message, optional, tag = "3")]
    pub columns: ::core::option::Option<pushdowns::Columns>,
    #[prost(uint64, optional, tag = "4")]
    pub limit: ::core::option::Option<u64>,
}
/// Nested message and enum types in `Pushdowns`.
pub mod pushdowns {
    /// Columns in pushdowns are not bound in the representation.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Columns {
        #[prost(string, repeated, tag = "1")]
        pub columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    }
}
/// ScanTasks is just typed list.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScanTasks {
    #[prost(message, repeated, tag = "1")]
    pub tasks: ::prost::alloc::vec::Vec<ScanTask>,
}
/// ScanTask definition could be added later, it's a lot of work.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScanTask {
    /// bincode
    #[prost(bytes = "vec", tag = "1")]
    pub task: ::prost::alloc::vec::Vec<u8>,
}
/// See SQL <aggregate function> for details on measure, we will have a filter field at some point.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Measure {
    #[prost(message, optional, tag = "1")]
    pub agg: ::core::option::Option<Agg>,
    /// The logical plans reify bindings as alias expressions.
    /// This is not desirable and does not accurately model the domain, but
    /// it's fine and I can re-create the binding alias with this optional field.
    ///
    /// optional Expr filter = 3;
    #[prost(string, optional, tag = "2")]
    pub alias: ::core::option::Option<::prost::alloc::string::String>,
}
/// See SQL-99 <aggregate function> for variants.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Agg {
    #[prost(oneof = "agg::Variant", tags = "1, 2, 3, 4, 5")]
    pub variant: ::core::option::Option<agg::Variant>,
}
/// Nested message and enum types in `Agg`.
pub mod agg {
    /// avg, max, min, sum, stddev, skew
    /// any, every, some, bool_and, bool_or
    /// count, count_all, count_nulls
    /// any_value
    /// agg_list, agg_set, agg_concat
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct SetFunction {
        #[prost(string, tag = "1")]
        pub name: ::prost::alloc::string::String,
        #[prost(message, repeated, tag = "2")]
        pub args: ::prost::alloc::vec::Vec<super::Expr>,
        #[prost(bool, tag = "3")]
        pub is_all: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ApproxPercentile {
        #[prost(message, optional, boxed, tag = "1")]
        pub expr: ::core::option::Option<::prost::alloc::boxed::Box<super::Expr>>,
        #[prost(double, repeated, tag = "2")]
        pub percentiles: ::prost::alloc::vec::Vec<f64>,
        #[prost(bool, tag = "3")]
        pub force_list_output: bool,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ApproxSketch {
        #[prost(message, optional, boxed, tag = "1")]
        pub expr: ::core::option::Option<::prost::alloc::boxed::Box<super::Expr>>,
        #[prost(enumeration = "SketchType", tag = "2")]
        pub sketch_type: i32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct MergeSketch {
        #[prost(message, optional, boxed, tag = "1")]
        pub expr: ::core::option::Option<::prost::alloc::boxed::Box<super::Expr>>,
        #[prost(enumeration = "SketchType", tag = "2")]
        pub sketch_type: i32,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct MapGroups {
        #[prost(message, optional, boxed, tag = "1")]
        pub func: ::core::option::Option<::prost::alloc::boxed::Box<super::Expr>>,
        #[prost(message, repeated, tag = "2")]
        pub inputs: ::prost::alloc::vec::Vec<super::Expr>,
    }
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum SketchType {
        Unspecified = 0,
        Dd = 1,
        Hll = 2,
    }
    impl SketchType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Unspecified => "SKETCH_TYPE_UNSPECIFIED",
                Self::Dd => "SKETCH_TYPE_DD",
                Self::Hll => "SKETCH_TYPE_HLL",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "SKETCH_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
                "SKETCH_TYPE_DD" => Some(Self::Dd),
                "SKETCH_TYPE_HLL" => Some(Self::Hll),
                _ => None,
            }
        }
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Variant {
        #[prost(message, tag = "1")]
        SetFunction(SetFunction),
        /// -- special forms
        #[prost(message, tag = "2")]
        ApproxPercentile(::prost::alloc::boxed::Box<ApproxPercentile>),
        #[prost(message, tag = "3")]
        ApproxSketch(::prost::alloc::boxed::Box<ApproxSketch>),
        #[prost(message, tag = "4")]
        MergeSketch(::prost::alloc::boxed::Box<MergeSketch>),
        #[prost(message, tag = "5")]
        MapGroups(::prost::alloc::boxed::Box<MapGroups>),
    }
}
/// / A type to leverage PyObjectWrapper's custom bincode serde.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PyObject {
    /// bincode
    #[prost(bytes = "vec", tag = "1")]
    pub object: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum TimeUnit {
    Unspecified = 0,
    Nanoseconds = 1,
    Microseconds = 2,
    Seconds = 3,
}
impl TimeUnit {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "TIME_UNIT_UNSPECIFIED",
            Self::Nanoseconds => "TIME_UNIT_NANOSECONDS",
            Self::Microseconds => "TIME_UNIT_MICROSECONDS",
            Self::Seconds => "TIME_UNIT_SECONDS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "TIME_UNIT_UNSPECIFIED" => Some(Self::Unspecified),
            "TIME_UNIT_NANOSECONDS" => Some(Self::Nanoseconds),
            "TIME_UNIT_MICROSECONDS" => Some(Self::Microseconds),
            "TIME_UNIT_SECONDS" => Some(Self::Seconds),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ImageMode {
    Unspecified = 0,
    L = 1,
    La = 2,
    Rgb = 3,
    Rgba = 4,
    L16 = 5,
    La16 = 6,
    Rgb16 = 7,
    Rgba16 = 8,
    Rgb32f = 9,
    Rgba32f = 10,
}
impl ImageMode {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "IMAGE_MODE_UNSPECIFIED",
            Self::L => "IMAGE_MODE_L",
            Self::La => "IMAGE_MODE_LA",
            Self::Rgb => "IMAGE_MODE_RGB",
            Self::Rgba => "IMAGE_MODE_RGBA",
            Self::L16 => "IMAGE_MODE_L16",
            Self::La16 => "IMAGE_MODE_LA16",
            Self::Rgb16 => "IMAGE_MODE_RGB16",
            Self::Rgba16 => "IMAGE_MODE_RGBA16",
            Self::Rgb32f => "IMAGE_MODE_RGB32F",
            Self::Rgba32f => "IMAGE_MODE_RGBA32F",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "IMAGE_MODE_UNSPECIFIED" => Some(Self::Unspecified),
            "IMAGE_MODE_L" => Some(Self::L),
            "IMAGE_MODE_LA" => Some(Self::La),
            "IMAGE_MODE_RGB" => Some(Self::Rgb),
            "IMAGE_MODE_RGBA" => Some(Self::Rgba),
            "IMAGE_MODE_L16" => Some(Self::L16),
            "IMAGE_MODE_LA16" => Some(Self::La16),
            "IMAGE_MODE_RGB16" => Some(Self::Rgb16),
            "IMAGE_MODE_RGBA16" => Some(Self::Rgba16),
            "IMAGE_MODE_RGB32F" => Some(Self::Rgb32f),
            "IMAGE_MODE_RGBA32F" => Some(Self::Rgba32f),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum FrameType {
    Unspecified = 0,
    Rows = 1,
    Range = 2,
    Groups = 3,
}
impl FrameType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "FRAME_TYPE_UNSPECIFIED",
            Self::Rows => "FRAME_TYPE_ROWS",
            Self::Range => "FRAME_TYPE_RANGE",
            Self::Groups => "FRAME_TYPE_GROUPS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "FRAME_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
            "FRAME_TYPE_ROWS" => Some(Self::Rows),
            "FRAME_TYPE_RANGE" => Some(Self::Range),
            "FRAME_TYPE_GROUPS" => Some(Self::Groups),
            _ => None,
        }
    }
}
/// SQL `<comp op>` for use in the `<quantified comparison predicate`
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum Comparison {
    Unspecified = 0,
    Eq = 1,
    Ne = 2,
    Lt = 3,
    Le = 4,
    Gt = 5,
    Ge = 6,
}
impl Comparison {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "COMPARISON_UNSPECIFIED",
            Self::Eq => "COMPARISON_EQ",
            Self::Ne => "COMPARISON_NE",
            Self::Lt => "COMPARISON_LT",
            Self::Le => "COMPARISON_LE",
            Self::Gt => "COMPARISON_GT",
            Self::Ge => "COMPARISON_GE",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "COMPARISON_UNSPECIFIED" => Some(Self::Unspecified),
            "COMPARISON_EQ" => Some(Self::Eq),
            "COMPARISON_NE" => Some(Self::Ne),
            "COMPARISON_LT" => Some(Self::Lt),
            "COMPARISON_LE" => Some(Self::Le),
            "COMPARISON_GT" => Some(Self::Gt),
            "COMPARISON_GE" => Some(Self::Ge),
            _ => None,
        }
    }
}
/// See SQL `<quantifier>` for use in the `<quantified comparison predicate>`
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum Quantifier {
    Unspecified = 0,
    Any = 1,
    All = 2,
    Some = 3,
}
impl Quantifier {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "QUANTIFIER_UNSPECIFIED",
            Self::Any => "QUANTIFIER_ANY",
            Self::All => "QUANTIFIER_ALL",
            Self::Some => "QUANTIFIER_SOME",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "QUANTIFIER_UNSPECIFIED" => Some(Self::Unspecified),
            "QUANTIFIER_ANY" => Some(Self::Any),
            "QUANTIFIER_ALL" => Some(Self::All),
            "QUANTIFIER_SOME" => Some(Self::Some),
            _ => None,
        }
    }
}
/// Daft models binary operators as their own type, but this should be generalized at some point.
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum Operator {
    Unspecified = 0,
    Eq = 1,
    EqNullSafe = 2,
    NotEq = 3,
    Lt = 4,
    LtEq = 5,
    Gt = 6,
    GtEq = 7,
    Plus = 8,
    Minus = 9,
    Multiply = 10,
    TrueDivide = 11,
    FloorDivide = 12,
    Modulus = 13,
    And = 14,
    Or = 15,
    Xor = 16,
    ShiftLeft = 17,
    ShiftRight = 18,
}
impl Operator {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "OPERATOR_UNSPECIFIED",
            Self::Eq => "OPERATOR_EQ",
            Self::EqNullSafe => "OPERATOR_EQ_NULL_SAFE",
            Self::NotEq => "OPERATOR_NOT_EQ",
            Self::Lt => "OPERATOR_LT",
            Self::LtEq => "OPERATOR_LT_EQ",
            Self::Gt => "OPERATOR_GT",
            Self::GtEq => "OPERATOR_GT_EQ",
            Self::Plus => "OPERATOR_PLUS",
            Self::Minus => "OPERATOR_MINUS",
            Self::Multiply => "OPERATOR_MULTIPLY",
            Self::TrueDivide => "OPERATOR_TRUE_DIVIDE",
            Self::FloorDivide => "OPERATOR_FLOOR_DIVIDE",
            Self::Modulus => "OPERATOR_MODULUS",
            Self::And => "OPERATOR_AND",
            Self::Or => "OPERATOR_OR",
            Self::Xor => "OPERATOR_XOR",
            Self::ShiftLeft => "OPERATOR_SHIFT_LEFT",
            Self::ShiftRight => "OPERATOR_SHIFT_RIGHT",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "OPERATOR_UNSPECIFIED" => Some(Self::Unspecified),
            "OPERATOR_EQ" => Some(Self::Eq),
            "OPERATOR_EQ_NULL_SAFE" => Some(Self::EqNullSafe),
            "OPERATOR_NOT_EQ" => Some(Self::NotEq),
            "OPERATOR_LT" => Some(Self::Lt),
            "OPERATOR_LT_EQ" => Some(Self::LtEq),
            "OPERATOR_GT" => Some(Self::Gt),
            "OPERATOR_GT_EQ" => Some(Self::GtEq),
            "OPERATOR_PLUS" => Some(Self::Plus),
            "OPERATOR_MINUS" => Some(Self::Minus),
            "OPERATOR_MULTIPLY" => Some(Self::Multiply),
            "OPERATOR_TRUE_DIVIDE" => Some(Self::TrueDivide),
            "OPERATOR_FLOOR_DIVIDE" => Some(Self::FloorDivide),
            "OPERATOR_MODULUS" => Some(Self::Modulus),
            "OPERATOR_AND" => Some(Self::And),
            "OPERATOR_OR" => Some(Self::Or),
            "OPERATOR_XOR" => Some(Self::Xor),
            "OPERATOR_SHIFT_LEFT" => Some(Self::ShiftLeft),
            "OPERATOR_SHIFT_RIGHT" => Some(Self::ShiftRight),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum JoinSide {
    Unspecified = 0,
    Left = 1,
    Right = 2,
}
impl JoinSide {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "JOIN_SIDE_UNSPECIFIED",
            Self::Left => "JOIN_SIDE_LEFT",
            Self::Right => "JOIN_SIDE_RIGHT",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "JOIN_SIDE_UNSPECIFIED" => Some(Self::Unspecified),
            "JOIN_SIDE_LEFT" => Some(Self::Left),
            "JOIN_SIDE_RIGHT" => Some(Self::Right),
            _ => None,
        }
    }
}
