# coding: utf-8

"""
    QAnswer: Api Documentation

    APIs provided by QAnswer

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictInt, StrictStr
from typing import Any, Dict, List, Optional
from qanswer_sdk.models.qa_contexts import QaContexts
from qanswer_sdk.models.qa_table import QaTable
from qanswer_sdk.models.summa_server import SummaServer

from qanswer_sdk.api_client import ApiClient, RequestSerialized
from qanswer_sdk.api_response import ApiResponse
from qanswer_sdk.rest import RESTResponseType


class ConnectorRDFAnswerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def answer_context(
        self,
        username: StrictStr,
        kb: StrictStr,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> QaContexts:
        """Given a SPARQL query returns all information about the answer entities like label, description, images ... 


        :param username: (required)
        :type username: str
        :param kb: (required)
        :type kb: str
        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._answer_context_serialize(
            username=username,
            kb=kb,
            sparql_query=sparql_query,
            lang=lang,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaContexts",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def answer_context_with_http_info(
        self,
        username: StrictStr,
        kb: StrictStr,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[QaContexts]:
        """Given a SPARQL query returns all information about the answer entities like label, description, images ... 


        :param username: (required)
        :type username: str
        :param kb: (required)
        :type kb: str
        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._answer_context_serialize(
            username=username,
            kb=kb,
            sparql_query=sparql_query,
            lang=lang,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaContexts",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def answer_context_without_preload_content(
        self,
        username: StrictStr,
        kb: StrictStr,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Given a SPARQL query returns all information about the answer entities like label, description, images ... 


        :param username: (required)
        :type username: str
        :param kb: (required)
        :type kb: str
        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._answer_context_serialize(
            username=username,
            kb=kb,
            sparql_query=sparql_query,
            lang=lang,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaContexts",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _answer_context_serialize(
        self,
        username,
        kb,
        sparql_query,
        lang,
        timeout,
        q_answer_api_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if username is not None:
            
            _query_params.append(('username', username))
            
        if kb is not None:
            
            _query_params.append(('kb', kb))
            
        if lang is not None:
            
            _query_params.append(('lang', lang))
            
        if sparql_query is not None:
            
            _query_params.append(('sparqlQuery', sparql_query))
            
        if timeout is not None:
            
            _query_params.append(('timeout', timeout))
            
        # process the header parameters
        if q_answer_api_key is not None:
            _header_params['QAnswer-Api-Key'] = q_answer_api_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'QAnswer-Api-Key', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/connectors/rdf/answer/context',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def rdf(
        self,
        dataset: StrictStr,
        user: List[StrictStr],
        url: StrictStr,
        language: Optional[StrictStr] = None,
        accept: Optional[List[StrictStr]] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Gets back the RDF content to render


        :param dataset: (required)
        :type dataset: str
        :param user: (required)
        :type user: List[str]
        :param url: (required)
        :type url: str
        :param language:
        :type language: str
        :param accept:
        :type accept: List[str]
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rdf_serialize(
            dataset=dataset,
            user=user,
            url=url,
            language=language,
            accept=accept,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def rdf_with_http_info(
        self,
        dataset: StrictStr,
        user: List[StrictStr],
        url: StrictStr,
        language: Optional[StrictStr] = None,
        accept: Optional[List[StrictStr]] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Gets back the RDF content to render


        :param dataset: (required)
        :type dataset: str
        :param user: (required)
        :type user: List[str]
        :param url: (required)
        :type url: str
        :param language:
        :type language: str
        :param accept:
        :type accept: List[str]
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rdf_serialize(
            dataset=dataset,
            user=user,
            url=url,
            language=language,
            accept=accept,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def rdf_without_preload_content(
        self,
        dataset: StrictStr,
        user: List[StrictStr],
        url: StrictStr,
        language: Optional[StrictStr] = None,
        accept: Optional[List[StrictStr]] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets back the RDF content to render


        :param dataset: (required)
        :type dataset: str
        :param user: (required)
        :type user: List[str]
        :param url: (required)
        :type url: str
        :param language:
        :type language: str
        :param accept:
        :type accept: List[str]
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._rdf_serialize(
            dataset=dataset,
            user=user,
            url=url,
            language=language,
            accept=accept,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _rdf_serialize(
        self,
        dataset,
        user,
        url,
        language,
        accept,
        q_answer_api_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'user': 'csv',
            'accept': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if dataset is not None:
            _path_params['dataset'] = dataset
        if user is not None:
            _path_params['user'] = user
        # process the query parameters
        if url is not None:
            
            _query_params.append(('url', url))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        # process the header parameters
        if accept is not None:
            _header_params['accept'] = accept
        if q_answer_api_key is not None:
            _header_params['QAnswer-Api-Key'] = q_answer_api_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'QAnswer-Api-Key', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/connectors/rdf/answer/browser/{user}/{dataset}/facet',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def summa(
        self,
        dataset: StrictStr,
        entity: StrictStr,
        user: List[StrictStr],
        top_k: Optional[StrictInt] = None,
        language: Optional[StrictStr] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SummaServer:
        """Generates summaries, i.e. most relevant top-k properties, for an item in a dataset


        :param dataset: (required)
        :type dataset: str
        :param entity: (required)
        :type entity: str
        :param user: (required)
        :type user: List[str]
        :param top_k:
        :type top_k: int
        :param language:
        :type language: str
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._summa_serialize(
            dataset=dataset,
            entity=entity,
            user=user,
            top_k=top_k,
            language=language,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SummaServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def summa_with_http_info(
        self,
        dataset: StrictStr,
        entity: StrictStr,
        user: List[StrictStr],
        top_k: Optional[StrictInt] = None,
        language: Optional[StrictStr] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SummaServer]:
        """Generates summaries, i.e. most relevant top-k properties, for an item in a dataset


        :param dataset: (required)
        :type dataset: str
        :param entity: (required)
        :type entity: str
        :param user: (required)
        :type user: List[str]
        :param top_k:
        :type top_k: int
        :param language:
        :type language: str
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._summa_serialize(
            dataset=dataset,
            entity=entity,
            user=user,
            top_k=top_k,
            language=language,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SummaServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def summa_without_preload_content(
        self,
        dataset: StrictStr,
        entity: StrictStr,
        user: List[StrictStr],
        top_k: Optional[StrictInt] = None,
        language: Optional[StrictStr] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates summaries, i.e. most relevant top-k properties, for an item in a dataset


        :param dataset: (required)
        :type dataset: str
        :param entity: (required)
        :type entity: str
        :param user: (required)
        :type user: List[str]
        :param top_k:
        :type top_k: int
        :param language:
        :type language: str
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._summa_serialize(
            dataset=dataset,
            entity=entity,
            user=user,
            top_k=top_k,
            language=language,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SummaServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _summa_serialize(
        self,
        dataset,
        entity,
        user,
        top_k,
        language,
        q_answer_api_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'user': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if dataset is not None:
            _path_params['dataset'] = dataset
        # process the query parameters
        if entity is not None:
            
            _query_params.append(('entity', entity))
            
        if top_k is not None:
            
            _query_params.append(('topK', top_k))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if user is not None:
            
            _query_params.append(('user', user))
            
        # process the header parameters
        if q_answer_api_key is not None:
            _header_params['QAnswer-Api-Key'] = q_answer_api_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    '*/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'QAnswer-Api-Key', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/connectors/rdf/answer/summaserver/{dataset}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def table_context(
        self,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        kb: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        username: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> QaTable:
        """Given a SPARQL query returns the information about the answer entities in the form of a table.


        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param kb:
        :type kb: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param username:
        :type username: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._table_context_serialize(
            sparql_query=sparql_query,
            lang=lang,
            kb=kb,
            limit=limit,
            offset=offset,
            username=username,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaTable",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def table_context_with_http_info(
        self,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        kb: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        username: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[QaTable]:
        """Given a SPARQL query returns the information about the answer entities in the form of a table.


        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param kb:
        :type kb: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param username:
        :type username: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._table_context_serialize(
            sparql_query=sparql_query,
            lang=lang,
            kb=kb,
            limit=limit,
            offset=offset,
            username=username,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaTable",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def table_context_without_preload_content(
        self,
        sparql_query: StrictStr,
        lang: Optional[StrictStr] = None,
        kb: Optional[StrictStr] = None,
        limit: Optional[StrictInt] = None,
        offset: Optional[StrictInt] = None,
        username: Optional[StrictStr] = None,
        timeout: Optional[StrictInt] = None,
        q_answer_api_key: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Given a SPARQL query returns the information about the answer entities in the form of a table.


        :param sparql_query: (required)
        :type sparql_query: str
        :param lang:
        :type lang: str
        :param kb:
        :type kb: str
        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param username:
        :type username: str
        :param timeout:
        :type timeout: int
        :param q_answer_api_key:
        :type q_answer_api_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._table_context_serialize(
            sparql_query=sparql_query,
            lang=lang,
            kb=kb,
            limit=limit,
            offset=offset,
            username=username,
            timeout=timeout,
            q_answer_api_key=q_answer_api_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QaTable",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _table_context_serialize(
        self,
        sparql_query,
        lang,
        kb,
        limit,
        offset,
        username,
        timeout,
        q_answer_api_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if lang is not None:
            
            _query_params.append(('lang', lang))
            
        if kb is not None:
            
            _query_params.append(('kb', kb))
            
        if sparql_query is not None:
            
            _query_params.append(('sparqlQuery', sparql_query))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if timeout is not None:
            
            _query_params.append(('timeout', timeout))
            
        # process the header parameters
        if q_answer_api_key is not None:
            _header_params['QAnswer-Api-Key'] = q_answer_api_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'QAnswer-Api-Key', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/connectors/rdf/answer/table',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


